#ifndef _CURSES_GLUE_H
#define _CURSES_GLUE_H

#include <ncurses.h>
#include <KayaAPI.h>

#define DECLKEY(x) char key_## x();
#define DEFKEY(x) char key_## x() { return KEY_## x; }

extern "C" {
    bool testerr(int x);

    void docbreak();
    void donocbreak();
    void doecho();
    void donoecho();
    void donl();
    void dononl();
    void doraw();
    void donoraw();

    WINDOW* getstdscr();
    void dointrflush(void* v, bool bf);
    void dokeypad(void* v, bool bf);
    void dometa(void* v, bool bf);
    void donodelay(void* v, bool bf);
    void donotimeout(void* v, bool bf);

    void dorefresh();
    void dowrefresh(void* win);

    void dowmove(void* w, int y, int x);
    void domove(int y, int x);

    char dogetch();
    char domvgetch(int x, int y);
    char dowgetch(void* win);
    char dowmvgetch(void* win, int x, int y);

    char* dogetstr();
    char* dowgetstr(void* win);

    void doaddstr(char * s);
    void dowaddstr(void* w, char * s);

    int doattron(KayaArray attribs);
    int doattroff(KayaArray attribs);
    int dowattron(void* w,KayaArray attribs);
    int dowattroff(void* w,KayaArray attribs);

    int getBlack();
    int getRed();
    int getGreen();
    int getYellow();
    int getBlue();
    int getMagenta();
    int getCyan();
    int getWhite();
    int getColourPairs();
    int getColours();

    void* donewwin(int l, int c,int y, int x);
    int dodelwin(void* win);
    int domvwin(void* win, int y, int x);

    DECLKEY(DOWN);
    DECLKEY(UP);
    DECLKEY(LEFT);
    DECLKEY(RIGHT);
    DECLKEY(HOME);
    DECLKEY(END);
    DECLKEY(BACKSPACE);
    DECLKEY(A1);
    DECLKEY(A3);
    DECLKEY(B2);
    DECLKEY(C1);
    DECLKEY(C3);

    int dobox(void* win,char x, char y);

    void doclear();
    void doerase();
    void doclrtobot();
    void doclrtoeol();
    void dowclear(void* p);
    void dowerase(void* p);
    void dowclrtobot(void* p);
    void dowclrtoeol(void* p);
}

#endif
