#include <iostream>

#include "regex_glue.h"
#include "Heap.h"
#include "VM.h"

void* re_compile(char* pattern)
{
    const char* error;
    int erroffset;
    pcre* re =  pcre_compile(pattern,0,&error, &erroffset, NULL);
    return (void*)re;
}

void* re_match(void* pc, char* str)
{
    int ovector[255];
    Match* m = new Match();

    pcre* re = (pcre*)pc;
    int rc = pcre_exec(re, NULL, str, strlen(str), 0, 0, ovector, 255);
    int len = strlen(str);

//    cout << rc << endl;

    if (rc>=0) {
	m->matched = true;
	m->matches = new Array();

	m->before = (char*)GC_MALLOC((ovector[0]+1)*sizeof(char));
	strncpy(m->before, str,ovector[0]);
	m->before[ovector[0]]='\0';

	int afterlen = len-ovector[1];
	m->after = (char*)GC_MALLOC((afterlen+1)*sizeof(char));
	strncpy(m->after, str+ovector[1],afterlen);
	m->after[afterlen]='\0';

	for(int i=0;i<rc;i++) {
//	    cout << ovector[i*2] << "-" << ovector[i*2+1] << endl;
	    const char* sub;
	    pcre_get_substring(str, ovector, rc, i, &sub);
	    char* val = (char*)GC_MALLOC((strlen(sub)+1)*sizeof(char));
	    strcpy(val,sub);
	    m->matches->push_back(new Value(new String(val),stringtable));
	}
    }
    else
    {
	m->matched = false;
	m->matches = new Array();
    }
    return (void*)m;
}

Array* getmatches(void* mo)
{
    return ((Match*)mo)->matches;
}

bool matched(void* mo)
{
    return ((Match*)mo)->matched;
}

char* getBefore(void* mo)
{
    return ((Match*)mo)->before;    
}

char* getAfter(void* mo)
{
    return ((Match*)mo)->after;    
}
