#include <gnutls/gnutls.h>
#include <VMState.h>
#include <KayaAPI.h>
#include "tls_glue.h"
#include "network_glue.h"

#if LIBGNUTLS_VERSION_MINOR >= 2
#define GSESSTYPE gnutls_session_t
#define GCERTTYPE gnutls_certificate_credentials_t
#define GTRANTYPE gnutls_transport_ptr_t
#else
#define GSESSTYPE gnutls_session
#define GCERTTYPE gnutls_certificate_credentials
#define GTRANTYPE gnutls_transport_ptr
#endif

void* do_gnutls_makecred() {
  GCERTTYPE cred;
  gnutls_certificate_allocate_credentials (&cred);
  return (void*)cred;
}

void* do_gnutls_init(void* cred) {
  GSESSTYPE session;
  const int cert_type_priority[3] = { GNUTLS_CRT_X509, GNUTLS_CRT_OPENPGP, 0 };
  gnutls_init (&session, GNUTLS_CLIENT);
  gnutls_set_default_priority(session);
  gnutls_certificate_type_set_priority(session,cert_type_priority);
  gnutls_credentials_set (session, GNUTLS_CRD_CERTIFICATE, (GCERTTYPE) cred);
  return (void*)session;
}

int do_gnutls_transport(void* rawtls, void* rawconn) {
  GSESSTYPE tls = (GSESSTYPE) rawtls;
  ConnInfo* c = (ConnInfo*) rawconn;
  gnutls_transport_set_ptr(tls, (GTRANTYPE) c->cid);
  return gnutls_handshake(tls);
}

void do_gnutls_put(void* rawtls, wchar_t* rawdat) {
  GSESSTYPE tls = (GSESSTYPE) rawtls;
  char* dat = CSTRING(rawdat);
  gnutls_record_send(tls,dat,strlen(dat));
}

wchar_t* do_gnutls_get(void* rawtls, void* vmptr) {
  GSESSTYPE tls = (GSESSTYPE) rawtls;
  char buffer[1025];
  int ret = gnutls_record_recv(tls, buffer, 1024);
  if (ret < 0) {
    VMState* vm = (VMState*)vmptr;
    vm->kaya_throw("TLS error while receiving",1);
  }
  buffer[ret] = '\0';
  return KSTRING(buffer);
}

void do_gnutls_close(void* rawtls, void* rawcred) {
  GSESSTYPE tls = (GSESSTYPE) rawtls;
  GCERTTYPE cred = (GCERTTYPE) rawcred;
  gnutls_bye(tls, GNUTLS_SHUT_RDWR);
  gnutls_deinit(tls);
  gnutls_certificate_free_credentials(cred);
}
