#include "pdcurses_glue.h"
#include <curses.h>

bool testerr(int x) {
    return x == ERR;
}

void docbreak() { cbreak(); }
void donocbreak() { nocbreak(); }
void doecho() { echo(); }
void donoecho() { noecho(); }
void donl() { nl(); }
void dononl() { nonl(); }
void doraw() { raw(); }
void donoraw() { noraw(); }

WINDOW* getstdscr() {
    return stdscr;
}

void dokeypad(void* v, bool bf) {
    WINDOW* w = (WINDOW*)v;
    keypad(w,bf);
}

void dointrflush(void* v, bool bf) {
    intrflush((WINDOW*)v,bf);
}

void dometa(void* v, bool bf) {
    meta((WINDOW*)v,bf);
}

void donotimeout(void* v, bool bf) {
    notimeout((WINDOW*)v,bf);
}

void dorefresh() {
    refresh();
}

void dowrefresh(void* win) {
//    char buf[50];
//    sprintf(buf,"Refreshing %d",win);
//    addstr(buf);
    wrefresh((WINDOW*)win);
}

void dowmove(void* w, int y, int x) {
    wmove((WINDOW*)w,y,x);
}

void domove(int y, int x) {
    move(y,x);
}


void doaddstr(wchar_t * s)
{
    addstr(CSTRING(s));
}

void dowaddstr(void* w, wchar_t * s)
{
    waddstr((WINDOW*)w, CSTRING(s));
}

int mkAtt(KayaValue v)
{
    int tag = KayaUnionGetTag(v);
    switch(tag) {
    case 0:
	return A_NORMAL; 
	break;
    case 1:
	return A_STANDOUT;
	break;
    case 2:
	return A_UNDERLINE;
	break;
    case 3:
	return A_REVERSE;
	break;
    case 4:
	return A_BLINK;
	break;
    case 5:
	return A_DIM;
	break;
    case 6:
	return A_BOLD;
	break;
    case 7:
	return A_PROTECT;
	break;
    case 8:
	return A_INVIS;
	break;
    case 9:
	return A_ALTCHARSET;
	break;
    case 10:
	return A_CHARTEXT;
	break;
    case 11:
	return COLOR_PAIR(KayaGetInt(KayaUnionGetArg(v,0)));
	break;
    }
}

int att_to_int(KayaArray attribs)
{
    int a=0;
    for(int i=0;i<KayaArraySize(attribs);i++) {
	KayaValue x = KayaArrayLookup(attribs,i);
	a = a | (mkAtt(x));
    }
    return a;
}

int doattron(KayaArray attribs)
{
    return attron(att_to_int(attribs));
}

int doattroff(KayaArray attribs)
{
    return attroff(att_to_int(attribs));
}

int dowattron(void* win, KayaArray attribs)
{
    return wattron((WINDOW*)win,att_to_int(attribs));
}

int dowattroff(void* win, KayaArray attribs)
{
    return wattroff((WINDOW*)win,att_to_int(attribs));
}

wchar_t dogetch()
{
    return KACHAR(getch());
}

wchar_t domvgetch(int y, int x)
{
    return KACHAR(mvgetch(y,x));
}

wchar_t dowgetch(void* win)
{
    return KACHAR(wgetch((WINDOW*)win));
}

wchar_t dowmvgetch(void* win, int y, int x)
{
    return KACHAR(mvwgetch((WINDOW*)win,y,x));
}

wchar_t* dogetstr()
{
    char* buf = (char*)(KayaAlloc(255));
    getnstr(buf,255);
    return KSTRING(buf);
}

wchar_t* dowgetstr(void* win)
{
    char* buf = (char*)(KayaAlloc(255));
    wgetnstr((WINDOW*)win,buf,255);
    return KSTRING(buf);
}

int getBlack()
{
    return COLOR_BLACK;
}

int getRed()
{
    return COLOR_RED;
}

int getGreen()
{
    return COLOR_GREEN;
}

int getYellow()
{
    return COLOR_YELLOW;
}

int getBlue()
{
    return COLOR_BLUE;
}

int getMagenta()
{
    return COLOR_MAGENTA;
}

int getCyan()
{
    return COLOR_CYAN;
}

int getWhite()
{
    return COLOR_WHITE;
}

int getColourPairs()
{
    return COLOR_PAIRS;
}

int getColours()
{
    return COLORS;
}

void* donewwin(int l, int c,int y, int x)
{
    void* win = (void*)(newwin(l,c,y,x));
//    char buf[50];
//    sprintf(buf,"New win %d",win);
//    addstr(buf);
    return win;
}

int dodelwin(void* win) {
    return delwin((WINDOW*)win);
}

int domvwin(void* win, int y, int x) {
    return mvwin((WINDOW*)win, y, x);
}

DEFKEY(DOWN);
DEFKEY(UP);
DEFKEY(LEFT);
DEFKEY(RIGHT);
DEFKEY(BACKSPACE);
DEFKEY(A1);
DEFKEY(A3);
DEFKEY(B2);
DEFKEY(C1);
DEFKEY(C3);
DEFKEY(HOME);
DEFKEY(END);
DEFKEY(PPAGE);
DEFKEY(NPAGE);

// function keys
DEFKEYF(1);
DEFKEYF(2);
DEFKEYF(3);
DEFKEYF(4);
DEFKEYF(5);
DEFKEYF(6);
DEFKEYF(7);
DEFKEYF(8);
DEFKEYF(9);
DEFKEYF(10);
DEFKEYF(11);
DEFKEYF(12);

int dobox(void* win,wchar_t x, wchar_t y)
{
//    char buf[50];
//    sprintf(buf,"Boxing %d",win);
//    addstr(buf);
    return box((WINDOW*)win,*wctostr(&x),*wctostr(&y));
}

void doclear()
{
    clear();
}

void doerase()
{
    erase();
}

void doclrtobot()
{
    clrtobot();
}

void doclrtoeol()
{
    clrtoeol();
}

void dowclear(void* p)
{
    wclear((WINDOW*)p);
}

void dowerase(void* p)
{
    werase((WINDOW*)p);
}

void dowclrtobot(void* p)
{
    wclrtobot((WINDOW*)p);
}

void dowclrtoeol(void* p)
{
    wclrtoeol((WINDOW*)p);
}
