#ifndef _VALUEFUNS_H
#define _VALUEFUNS_H

/**
    Kaya run-time system
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence.
*/

#include <vector>
#include <map>

class Value;
class VMState;

typedef enum { KVT_NULL, KVT_INT, KVT_STRING, KVT_FUNC, KVT_ARRAY, KVT_UNION, KVT_EXCEPTION, KVT_REAL } valtype;

extern "C" {
    kint inttable_eq(Value*, Value*, map<Value*,Value*>& done);
    kint inttable_fasteq(Value*, Value*);
    kint inttable_cmp(Value*, Value*);
    Value* inttable_copy(Value*, map<Value*,Value*>& done);
    Value* inttable_fastcopy(Value*);
    Value* inttable_marshal(VMState*, vector<Value*>&, Value*, int id);
    Value* inttable_reflect(VMState*, map<Value*, Value*>&, Value*);
    Value* inttable_hash(Value*);
    int inttable_memusage(Value*);

    kint fntable_eq(Value*, Value*, map<Value*,Value*>& done);
    kint fntable_cmp(Value*, Value*);
    Value* fntable_copy(Value*, map<Value*,Value*>& done);
    Value* fntable_marshal(VMState*, vector<Value*>&, Value*, int id);
    Value* fntable_reflect(VMState*, map<Value*, Value*>&, Value*);
    Value* fntable_hash(Value*);
    int fntable_memusage(Value*);

    kint realtable_eq(Value*, Value*, map<Value*,Value*>& done);
    kint realtable_fasteq(Value*, Value*);
    kint realtable_cmp(Value*, Value*);
    Value* realtable_copy(Value*, map<Value*,Value*>& done);
    Value* realtable_fastcopy(Value*);
    Value* realtable_marshal(VMState*, vector<Value*>&, Value*, int id);
    Value* realtable_reflect(VMState*, map<Value*, Value*>&, Value*);
    Value* realtable_hash(Value*);
    int realtable_memusage(Value*);

    kint stringtable_eq(Value*, Value*, map<Value*,Value*>& done);
    kint stringtable_fasteq(Value*, Value*);
    kint stringtable_cmp(Value*, Value*);
    Value* stringtable_copy(Value*, map<Value*,Value*>& done);
    Value* stringtable_fastcopy(Value*);
    Value* stringtable_marshal(VMState*, vector<Value*>&, Value*, int id);
    Value* stringtable_reflect(VMState*, map<Value*, Value*>&, Value*);
    Value* stringtable_hash(Value*);
    int stringtable_memusage(Value*);

    kint arraytable_eq(Value*, Value*, map<Value*,Value*>& done);
    kint arraytable_cmp(Value*, Value*);
    Value* arraytable_copy(Value*, map<Value*,Value*>& done);
    Value* arraytable_marshal(VMState*, vector<Value*>&, Value*, int id);
    Value* arraytable_reflect(VMState*, map<Value*, Value*>&, Value*);
    Value* arraytable_hash(Value*);
    int arraytable_memusage(Value*);

    kint uniontable_eq(Value*, Value*, map<Value*,Value*>& done);
    kint uniontable_cmp(Value*, Value*);
    Value* uniontable_copy(Value*, map<Value*,Value*>& done);
    Value* uniontable_marshal(VMState*, vector<Value*>&, Value*, int id);
    Value* uniontable_reflect(VMState*, map<Value*, Value*>&, Value*);
    Value* uniontable_hash(Value*);
    int uniontable_memusage(Value*);

    kint exceptiontable_eq(Value*, Value*, map<Value*,Value*>& done);
    kint exceptiontable_fasteq(Value*, Value*);
    kint exceptiontable_cmp(Value*, Value*);
    Value* exceptiontable_copy(Value*, map<Value*,Value*>& done);
    Value* exceptiontable_fastcopy(Value*);
    Value* exceptiontable_marshal(VMState*, vector<Value*>&, Value*, int id);
    Value* exceptiontable_reflect(VMState*, map<Value*, Value*>&, Value*);
    Value* exceptiontable_hash(Value*);
    int exceptiontable_memusage(Value*);
}

#endif
