#ifndef _STDFUNS_H
#define _STDFUNS_H

/**
    Kaya run-time system
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence.
*/

// Standard functions for linking into the standard library

#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include "Heap.h"
#include "KayaAPI.h"
#include "unpickler.h"
#include <map>
#include "sizes.h"

typedef map<wchar_t*,wchar_t*> ArgMap;

extern KayaArray args;

wchar_t* inttostr(int s, int base);
int strtoint(wchar_t* str, int base);

wchar_t* getsubstr(wchar_t* x,int i,int len);
void str_offset(Value* str, int inc);
void str_chop(Value* str, int inc);
wchar_t* getstrend(wchar_t* x,int i);
wchar_t* readstr();

wchar_t getIndex(wchar_t* str,int i);
void setIndex(wchar_t* str, wchar_t c,int i);

wchar_t* do_urlencode(void* vm, wchar_t* strinwide);
wchar_t* do_urldecode(void* vm, wchar_t* strinwide);

wchar_t* getLine(FILE* file);
wchar_t* getString(FILE* file);
void putString(FILE* f, wchar_t* c);
void putLine(FILE* f, wchar_t* c);
void do_fseek(FILE* f, kint p);
kint do_ftell(FILE* f);

void putStr(wchar_t* c);
// Check if a string has any UTF8 characters in it (return non-zero if so)
int topSet(const char* str);
int checkUTF8(wchar_t* str);
void putU8Str(wchar_t* c);

FILE* getstdin();
FILE* getstdout();
FILE* getstderr();
void setStdErr(FILE* f);

bool validFile(FILE* f);

void printArray(KayaArray foo);
KayaArray reverseArray(KayaArray foo);
void shortenArray(KayaArray foo);
KayaValue shiftArray(KayaArray foo);
KayaArray createArray(int size);
void resizeArray(KayaArray foo, int size);
int arraySize(KayaArray foo);

// these really are char*
void storeArgs(int argc,char* argv[]);
KayaArray getArgs();

int gettime();
int getclock();
kint dogettimeofday();
#ifdef WIN32
int gettimeofday (struct timeval *tp, void *tz);
#endif
KayaValue dogmtime(int secs);
KayaValue dolocaltime(int secs);
int domktime(KayaValue time);

int runProgram(wchar_t* prog, KayaArray args);
int dofork();
int dowait();
int dowaitpid(int pid);
void reap();

int dogetpid();

bool do_wcschr(wchar_t c, wchar_t* s);
int do_wcscspn(wchar_t c, wchar_t* s);

wchar_t* b64enc(wchar_t* block, int len);
wchar_t* b64dec(wchar_t* block, KayaValue len);
char* b64enc(char* block, int len);
char* b64dec(char* block, KayaValue len);

wchar_t* mkString(KayaValue x);

void quicksort(void* vm, KayaArray xs, KayaValue sortfn);

#define FUNTABLE_OP(op,x,y) \
switch (x->getFunTable()) { \
  case KVT_INT: \
    r = inttable_##op(x,y); \
    break; \
  case KVT_STRING: \
    r = stringtable_##op(x,y); \
    break; \
  case KVT_FUNC: \
    r = fntable_##op(x,y); \
    break; \
  case KVT_ARRAY: \
    r = arraytable_##op(x,y); \
    break; \
  case KVT_UNION: \
    r = uniontable_##op(x,y); \
    break; \
  case KVT_EXCEPTION: \
    r = exceptiontable_##op(x,y); \
    break; \
  case KVT_REAL: \
    r = realtable_##op(x,y); \
    break; \
  case KVT_NULL: \
    r = inttable_##op(x,y); \
    break; \
  } 
/* KVT_NULL can't happen */

// #define funtable_compare(x,y) x->getFunTable()->cmp(x,y)
#define funtable_eq(v,x,y) (x==y || funtable_equal(v,x,y))
#define funtable_eq_aux(x,y,done) (x==y || funtable_equal_aux(x,y,done))

int funtable_compare(void* vmptr, KayaValue x, KayaValue y);
bool funtable_equal(void* vmptr, KayaValue x, KayaValue y);
bool funtable_equal_aux(KayaValue x, KayaValue y, map<Value*,Value*>& done);
int funtable_hash(KayaValue x);
int funtable_memusage(KayaValue x);
wchar_t* funtable_marshal(void* vmptr,KayaValue x,int id);
wchar_t* funtable_marshal_aux(void* vmptr,vector<KayaValue>& done,KayaValue x, int i);
Value* funtable_reflect(void* vmptr,KayaValue x);
Value* funtable_reflect_aux(void* vmptr,
			    map<KayaValue, KayaValue>& done,KayaValue x);
KayaValue funtable_copy(void* vmptr, KayaValue x);
KayaValue funtable_copy_aux(KayaValue x, map<Value*, Value*>& done);

KayaValue reifyUnion(int tag, int arity);
void reifyUnionArgs(KayaValue v, KayaArray flds);
KayaValue reifyClosure(int tag, int arity);
void reifyClosureArgs(KayaValue v, KayaArray flds);

bool is_initialised(KayaValue x);
KayaValue unsafe_id(KayaValue x);

wchar_t* getAddr(KayaValue x);

wchar_t* except_msg(KayaValue x);
int except_code(KayaValue x);
void except_dumpbt(KayaValue x);

int doGetFnID(KayaValue fn);
void callFnID(void* vmptr, int id, KayaValue arg);

int memusage();

int isNull(void* p);
int isIdentical(KayaValue x, KayaValue y);
int maxMemUsage(void* vmptr);

// Added by Chris Morris, 18/6/05
int do_access(wchar_t* pathname, KayaValue mode);
// Added by Chris Morris, 5/9/05
int do_unlink(const wchar_t* fn);
wchar_t* dogetcwd();
int do_mkdir(const wchar_t* fn, int um);

int do_setrlimit(KayaValue lim, int soft, int hard);

// Directory functions, 28/8/05

void* do_opendir(wchar_t* name);
int do_closedir(void* dir);
void* do_readdir(void* dir);

wchar_t* dir_getname(void* ent);

KayaValue do_stat(void* vm, wchar_t* name);

FILE *do_fopen(const wchar_t* path, const wchar_t* mode);
FILE *do_freopen(const wchar_t* path, const wchar_t* mode, FILE* stream);
void do_rename(const wchar_t* oldfile, const wchar_t* newfile);
void do_chdir(const wchar_t* newdir);
wchar_t* do_getenv(const wchar_t* env);

kint binary_length(const wchar_t* str);

#ifndef WIN32
int do_system(const wchar_t* prog);
FILE* do_popen(const wchar_t* prog, int read);
int do_pclose(FILE* stream);
#endif

// Return next biggest power of 2.
int nextPower(int x);

int strAlloc(Value* str);
Value* createString(int len);

void do_GC_enable_incremental();

void do_sleep(int len);
void do_usleep(int len);

int strHash(wchar_t* m);

int rtchecks();

#endif
