// -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-

//
//  Copyright (C) 2003 Takuro Ashie
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include <xpcom/nsCOMPtr.h>
#include <docshell/nsIDocShell.h>
#include <dom/nsIDOMDocument.h>
#include <dom/nsIDOMWindow.h>
#include <webbrwsr/nsIWebBrowser.h>
#include <content/nsISelection.h>
#include <content/nsISelectionListener.h>
#include <nsString.h>
#include <nsIDOMEventReceiver.h>
#include <nsPIDOMWindow.h>
#include "kz-mozembed.h"


class KzMozSelectionListener : public nsISelectionListener
{
public:
	KzMozSelectionListener ();
	virtual ~KzMozSelectionListener ();

	nsresult Init    (KzMozEmbed *kzembed);
	void     Destroy (void);

	// nsISupports interface
	NS_DECL_ISUPPORTS

	// nsISelectionListerner interface
	NS_DECL_NSISELECTIONLISTENER

	// for selection
	nsresult GetSelection            (nsISelection **selection);
	nsresult AddSelectionListener    (void);
	nsresult RemoveSelectionListener (void);

protected:
	KzMozEmbed              *mKzMozEmbed;
	nsCOMPtr<nsIWebBrowser>  mWebBrowser;
	PRPackedBool             mSelectionWasCollapsed;
};
