/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Takuro Ashie <ashie@homa.ne.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 +  $Id: prefs_ui_editor.c,v 1.1 2004/03/12 08:05:28 makeinu Exp $
 */

#include "prefs_ui_editor.h"

#include "kazehakase.h"
#include "kz-window.h"
#include "kz-mozembed.h"
#include "mozilla-prefs.h"
#include "utils/intl.h"
#include "utils/gtk-utils.h"

#define DATA_KEY "KzPrefsUIEditor::info"


static GtkWidget     *prefs_ui_editor_create          (void);
static void           prefs_ui_editor_response        (GtkWidget *widget,
						       gint       response);


static KzPrefsWinPageEntry prefs_entry =
{
	path:            N_("/UI Editor"),
	priority_hint:   0,
	ui_level:        KZ_UI_LEVEL_EXPERT,
	create:          prefs_ui_editor_create,
	response:        prefs_ui_editor_response,
};


typedef struct _KzPrefsUIEditor
{
	GtkWidget     *main_vbox;
	GtkWidget     *notebook;
	gboolean       changed;
} KzPrefsGeneral;


static void
prefs_ui_editor_destroy (gpointer data)
{
	KzPrefsGeneral *prefsui = data;

	g_free(prefsui);
}


static GtkWidget *
create_ui_edit (void)
{
	GtkWidget *notebook, *label, *vbox;

	notebook = gtk_notebook_new();

	vbox = gtk_vbox_new(FALSE, 0);
	label = gtk_label_new("Layout");
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox, label);
	gtk_widget_show(vbox);
	gtk_widget_show(label);

	vbox = gtk_vbox_new(FALSE, 0);
	label = gtk_label_new("Main Menu");
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox, label);
	gtk_widget_show(vbox);
	gtk_widget_show(label);

	vbox = gtk_vbox_new(FALSE, 0);
	label = gtk_label_new("Popup Menus");
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox, label);
	gtk_widget_show(vbox);
	gtk_widget_show(label);

	vbox = gtk_vbox_new(FALSE, 0);
	label = gtk_label_new("Toolbar");
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox, label);
	gtk_widget_show(vbox);
	gtk_widget_show(label);

	return notebook;
}


static GtkWidget *
prefs_ui_editor_create (void)
{
	KzPrefsGeneral *prefsui = g_new0(KzPrefsGeneral, 1);
	GtkWidget *main_vbox, *label, *notebook[3];

	main_vbox = gtk_vbox_new(FALSE, 0);
	prefsui->main_vbox = main_vbox;
	g_object_set_data_full(G_OBJECT(main_vbox), DATA_KEY,
			       prefsui, prefs_ui_editor_destroy);

	label = kz_prefs_ui_utils_create_title(_("UI Editor"));
	gtk_box_pack_start(GTK_BOX(main_vbox), label,
			   FALSE, FALSE, 0);
	gtk_widget_show(label);

	notebook[0] = gtk_notebook_new();
	gtk_box_pack_start(GTK_BOX(main_vbox), notebook[0],
			   TRUE, TRUE, 0);
	gtk_widget_show(notebook[0]);

	notebook[1] = create_ui_edit();
	label = gtk_label_new("Main Window");
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook[0]), notebook[1], label);
	gtk_widget_show(notebook[1]);
	gtk_widget_show(label);

	notebook[2] = create_ui_edit();
	label = gtk_label_new("Bookmark Editor");
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook[0]), notebook[2], label);
	gtk_widget_show(notebook[2]);
	gtk_widget_show(label);

	prefsui->changed = FALSE;

	return main_vbox;
}



static void
prefs_ui_editor_response (GtkWidget *widget, gint response)
{
	KzPrefsGeneral *prefsui = g_object_get_data(G_OBJECT(widget), DATA_KEY);

	g_return_if_fail(prefsui);

	switch (response) {
	case GTK_RESPONSE_ACCEPT:
	case GTK_RESPONSE_APPLY:
		break;
	case GTK_RESPONSE_REJECT:
		break;
	case KZ_RESPONSE_UI_LEVEL_BEGINNER:
		break;
	case KZ_RESPONSE_UI_LEVEL_MEDIUM:
		break;
	case KZ_RESPONSE_UI_LEVEL_EXPERT:
		break;
	case KZ_RESPONSE_UI_LEVEL_CUSTOM:
		break;
	default:
		break;
	}
}


KzPrefsWinPageEntry *
prefs_ui_editor_get_entry (gint idx)
{
	if (idx == 0)
		return &prefs_entry;
	else
		return NULL;
}
