/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-plugin.h,v 1.3 2004/11/25 07:28:47 ikezoe Exp $
 */

#ifndef KZ_PLUGIN_H
#define KZ_PLUGIN_H

#include <glib-object.h>
#include <gmodule.h>

G_BEGIN_DECLS

#define KZ_TYPE_PLUGIN			(kz_plugin_get_type ())
#define KZ_PLUGIN(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_PLUGIN, KzPlugin))
#define KZ_PLUGIN_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_PLUGIN, KzPluginClass))
#define KZ_IS_PLUGIN(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_PLUGIN))
#define KZ_IS_PLUGIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_PLUGIN))
#define KZ_PLUGIN_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_PLUGIN, KzPluginClass))

typedef struct _KzPlugin      KzPlugin;
typedef struct _KzPluginClass KzPluginClass;
typedef struct _KzPluginPriv  KzPluginPriv;

struct _KzPlugin
{
	GObject       parent;

	GModule      *module;

	KzPluginPriv *priv;
};

struct _KzPluginClass
{
	GObjectClass parent_class;
};

GType        kz_plugin_get_type               (void) G_GNUC_CONST;
KzPlugin    *kz_plugin_new                    (const gchar *filename);

G_END_DECLS

#endif /* KZ_PLUGIN_H */
