/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_PRINT_DIALOG_H__
#define __KZ_PRINT_DIALOG_H__

#include <gtk/gtk.h>

#include "kz-window.h"
#include "kz-embed.h"

G_BEGIN_DECLS

#define KZ_TYPE_PRINT_DIALOG		   (kz_print_dialog_get_type ())
#define KZ_PRINT_DIALOG(obj)		   (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_PRINT_DIALOG, KzPrintDialog))
#define KZ_PRINT_DIALOG_CLASS(klass)	   (G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_PRINT_DIALOG, KzPrintDialogClass))
#define KZ_IS_PRINT_DIALOG(obj)	   (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_PRINT_DIALOG))
#define KZ_IS_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_PRINT_DIALOG))
#define KZ_PRINT_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_PRINT_DIALOG, KzPrintDialogClass))

typedef struct _KzPrintDialog           KzPrintDialog;
typedef struct _KzPrintDialogClass      KzPrintDialogClass;
typedef struct _KzPrintDialogPriv	KzPrintDialogPriv;

typedef enum
{
	KZ_PRINT_RANGE_ALL_PAGES,
	KZ_PRINT_RANGE_SPECIFIED_PAGES,
	KZ_PRINT_RANGE_SELECTION
} KzPrintRange;

typedef struct
{
	gboolean to_file;
        const gchar *filename;
	gchar *printer;
	
	KzPrintRange range;
	gint from_page;
	gint to_page;
} PrintInfo;

struct _KzPrintDialog
{
	GtkDialog parent;

	KzWindow     *kz;
	PrintInfo    *info;

	KzPrintDialogPriv *priv;
};

struct _KzPrintDialogClass
{
	GtkDialogClass parent_class;
};

GType            kz_print_dialog_get_type (void) G_GNUC_CONST;
GtkWidget       *kz_print_dialog_new      (KzWindow *kz);

PrintInfo	*kz_print_dialog_get_print_info (KzPrintDialog *print);

G_END_DECLS

#endif /* __KZ_PRINT_DIALOG_H__ */
