/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-mozthumbnailprogress.h"
#include "utils.h"

NS_IMPL_ISUPPORTS1(KzMozThumbnailProgressListener, nsIWebProgressListener)

KzMozThumbnailProgressListener::KzMozThumbnailProgressListener(const char *filename, KzMozThumbnailCreator *creator)
{
	NS_INIT_ISUPPORTS();
	mFilename = g_strdup(filename);
	mCreator = creator;
}


KzMozThumbnailProgressListener::~KzMozThumbnailProgressListener()
{
	kz_moz_thumbnail_creator_create_next(mCreator);
	mCreator = NULL;

	gchar *thumb_name;
	thumb_name = g_strndup(mFilename, strlen(mFilename) - 3);

	convert_image(mFilename, thumb_name);
	g_free(thumb_name);

	if (mFilename)
		g_free(mFilename);
	mFilename = NULL;

}


NS_IMETHODIMP
KzMozThumbnailProgressListener::OnStateChange(nsIWebProgress *aWebProgress,
				     	  nsIRequest     *aRequest,
				     	  PRUint32        aStateFlags,
				     	  nsresult        aStatus)
{
	if (aStateFlags & nsIWebProgressListener::STATE_STOP)
	{
		/* emit signal */	
	}

	return NS_OK;
}

NS_IMETHODIMP
KzMozThumbnailProgressListener::OnProgressChange(nsIWebProgress *aWebProgress,
					     nsIRequest     *aRequest,
					     PRInt32         aCurSelfProgress,
					     PRInt32         aMaxSelfProgress,
					     PRInt32         aCurTotalProgress,
					     PRInt32         aMaxTotalProgress)
{
	return NS_OK;
}

NS_IMETHODIMP
KzMozThumbnailProgressListener::OnLocationChange(nsIWebProgress *aWebProgress,
					     nsIRequest     *aRequest,
					     nsIURI         *aLocation)
{
	return NS_OK;
}

NS_IMETHODIMP
KzMozThumbnailProgressListener::OnStatusChange(nsIWebProgress  *aWebProgress,
				           nsIRequest      *aRequest,
				           nsresult         aStatus,
				           const PRUnichar *aMessage)
{
	return NS_OK;
}

NS_IMETHODIMP
KzMozThumbnailProgressListener::OnSecurityChange(nsIWebProgress *aWebProgress,
					     nsIRequest     *aRequest,
					     PRUint32         aState)
{
	return NS_OK;
}

