/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2009 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __KZ_XMLRPC_BOOKMARK_H__
#define __KZ_XMLRPC_BOOKMARK_H__

#include <glib-object.h>
#include "kz-bookmark-objects.h"
#include "kz-bookmark-file.h"

G_BEGIN_DECLS

#define KZ_TYPE_XMLRPC_BOOKMARK		(kz_xmlrpc_bookmark_get_type ())
#define KZ_XMLRPC_BOOKMARK(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_XMLRPC_BOOKMARK, KzXMLRPCBookmark))
#define KZ_XMLRPC_BOOKMARK_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_XMLRPC_BOOKMARK, KzXMLRPCBookmarkClass))
#define KZ_IS_XMLRPC_BOOKMARK(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_XMLRPC_BOOKMARK))
#define KZ_IS_XMLRPC_BOOKMARK_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_XMLRPC_BOOKMARK))
#define KZ_XMLRPC_BOOKMARK_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_XMLRPC_BOOKMARK, KzXMLRPCBookmarkClass))

typedef struct _KzXMLRPCBookmark    KzXMLRPCBookmark;
typedef struct _KzXMLRPCBookmarkClass    KzXMLRPCBookmarkClass;

struct _KzXMLRPCBookmark
{
	KzBookmarkFile parent;
};

struct _KzXMLRPCBookmarkClass
{
	KzBookmarkFileClass parent_class;
};

/* GType */
GType		kz_xmlrpc_bookmark_get_type	(void) G_GNUC_CONST;

/* boomark item creating functions */
KzXMLRPCBookmark     *kz_xmlrpc_bookmark_new	(const gchar *location,
						 const gchar *title,
						 const gchar *interface_uri,
						 const gchar *user_name,
						 const gchar *password);

const gchar    *kz_xmlrpc_bookmark_get_interface_uri (KzXMLRPCBookmark *bookmark);
const gchar    *kz_xmlrpc_bookmark_get_user_name     (KzXMLRPCBookmark *bookmark);
const gchar    *kz_xmlrpc_bookmark_get_password      (KzXMLRPCBookmark *bookmark);
void		kz_xmlrpc_bookmark_set_interface_uri (KzXMLRPCBookmark *bookmark,
						      const gchar      *uri);
void		kz_xmlrpc_bookmark_set_user_name     (KzXMLRPCBookmark *bookmark,
						      const gchar      *user_name);
void		kz_xmlrpc_bookmark_set_password	     (KzXMLRPCBookmark *bookmark,
						      const gchar      *password);

G_END_DECLS

#endif /* __KZ_XMLRPC_BOOKMARK_H__ */
