/***************************************************************************
                          tokenprovider.h  -  description
                             -------------------
    begin                : Fre Sep 19 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TOKENPROVIDER_H
#define TOKENPROVIDER_H

#include <qstring.h>

class QPaintDevice;

/** This class handles the replacement of tokens like [date] or [article_no].
  *
  *@author Dominik Seichter
  */
class TokenProvider {
    public: 
        TokenProvider( QPaintDevice* paintdevice );
        ~TokenProvider();

        void updateDone() { m_update = false; }
        bool update() const {
            return m_update && m_contains_update;
        }

        void setIndex( unsigned int index ) { m_index = index; m_update = true; }
        void setPage( unsigned int page ) { m_page = page; m_update = true; }
        void setArticleNo( const QString & t ) { article_no = t; m_update = true; }
        void setBarcodeNo( const QString & t ) { barcode_no = t; m_update = true; }
        void setCustomerNo( const QString & t ) { customer_no = t; m_update = true; }
        void setEncodingTypeName( const QString & t ) { encoding_type_name = t; m_update = true; }
        void setGroup( const QString & t ) { group = t; m_update = true; }
        void setLabelName( const QString & t ) { label_name = t; m_update = true; }

        int index() const { return m_index; }
        unsigned int page() const { return m_page; }
        const QString articleNo() const { return article_no; }        
        const QString barcodeNo() const { return barcode_no; }

        QPaintDevice* paintDevice() const { return m_printer; }

        /**
          * parse the given text for tokens and return a
          * string with all tokens replaced correctly.
          * @param text QString look in this text for tokens to replace
          */
        QString parse( const QString & text );
        
    private:
        QString findToken( QString token );
        QString findBrackets( QString text, int pos = -1 );

        /**
          * run a SQL Query and return it result
          * @param query QString the SQL command to execute
          */
        QString query( const QString & query );

        unsigned int m_index;
        unsigned int m_page;
        
        QString article_no;
        QString barcode_no;
        QString customer_no;
        QString encoding_type_name;
        QString group;
        QString label_name;
        
        bool m_update;
        bool m_contains_update;
        QPaintDevice* m_printer;
};

#endif
