#include "kbfxspinxlistbox.h"
//#include "cursor.xpm"
#include <qimage.h>
//#include <qpixmap.h>
#include <qapplication.h>
#include <qevent.h>
#include <qdragobject.h>


void
KbfxSpinxListBox::dragLeaveEvent (QDragLeaveEvent * e)
{

}

void
KbfxSpinxListBox::dragMoveEvent (QDragMoveEvent * e)
{

}

void
KbfxSpinxListBox::scroll (int delta)
{

  QWheelEvent we (QCursor::pos (), delta, Qt::NoButton);
  QApplication::sendEvent (this, &we);

}


void
KbfxSpinxListBox::scrollRest (int x)
{
  if (_type != 1)
    {
      this->move (this->x (), 0);
      scrolllen = 0;
    }

}


void
KbfxSpinxListBox::wheelEvent (QWheelEvent * e)
{

  uint count = this->count ();
  e->accept ();
  QListBoxItem *_item = this->firstItem ();
  if (_item == NULL || count < 6)
    return;
  qDebug ("I got WHeel Event , Hope to scroll");

  this->setGeometry (this->x (), this->y (), _item->width (this),
		     (_item->height (this) * count));
  int i = 0;

//FIXME:the fitlen needs to be calculated
  int fitlen = 5;

  int numberofitems = this->height () / _item->height (this);

  int visible = (_item->height (this) * (count - 5));
  if (_type == 1)
    {
      visible = (_item->height (this) * (count - 10));
    }

  if (e->delta () < 0 && scrolllen < visible && count > 4)
    {

      this->move (this->x (), this->y () - _item->height (this));
      scrolllen += _item->height (this);

    }
  else if (e->delta () > 0 && scrolllen != 0 && count > 4)
    {
      this->move (this->x (), this->y () + _item->height (this));
//mose wheel is moving away
      scrolllen -= _item->height (this);

    }
}

void
KbfxSpinxListBox::mouseMoveEvent (QMouseEvent * e)
{

  if (e->type () == QEvent::MouseMove && blocked)
    {
      QListBoxItem *_item = this->itemAt (e->pos ());
      *_selected = e->pos ();
      if (_item == NULL)
	{
	  this->clearFocus ();
	  return;
	}
      else
	{

	  QCursor kbfxCursor;
	  kbfxCursor.setShape (Qt::PointingHandCursor);
	  this->setCursor ((const QCursor) kbfxCursor);



	}
      this->setFocus ();
      _lastItem = (VistaListBoxItem *) _item;
      emit onItem (_item);
      this->setSelected (_item, true);

    }



}


void
KbfxSpinxListBox::leaveEvent (QEvent * e)
{
  if (!_type)
    this->clearFocus ();

}
