/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   sirajr@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "kbfxvista.h"
#include <kmessagebox.h>
#include <kglobal.h>
#include <klocale.h>
#include <kconfig.h>
#include <kapplication.h>

#include <qvariant.h>
#include <qlabel.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <qiconview.h>
#include <qframe.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qdir.h>
#include <kdesktopfile.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kicontheme.h>
#include <kprocess.h>
#include <qheader.h>
#include <qfileinfo.h>
#include <kmessagebox.h>
#include <krun.h>
#include <kurl.h>
#include <kservice.h>
#include <kservicegroup.h>
#include <qstringlist.h>
#include <kstandarddirs.h>
#include <kservicetype.h>

QPoint  kbfxvista::menupos()
{
    popinit();
    QRect r = QDesktopWidget().screenGeometry(this);
    int popy = (r.height() - (a->barheight+height()));
    QPoint xpoint = (this->mapToGlobal(QPoint(0,0)));
    int popx = xpoint.x();
    
    if (position() !=  pBottom )
    {
        return QPoint(this->mapToGlobal(this->geometry().bottomLeft()));
    }
    
    return QPoint(popx,popy);
}




void kbfxvista::showKmenu()
{

    // Import of old Kbfx code...
    /** note that there is no real way to know the 
    height of the K-menu 
    **/
    QByteArray data;
    QByteArray rdata;
    QDataStream arg (data, IO_WriteOnly);
    QCString replytype;
    
    QPoint ctmp (QCursor::pos());
    if( QCursor::pos().y() >  128) 
    {
        this->setCursor(Qt::BlankCursor);
        QCursor::setPos(this->mapToGlobal(QPoint(0,0)));
    }
    else
    {
        this->setCursor(Qt::BlankCursor);
            QCursor::setPos(this->mapToGlobal(this->geometry().bottomLeft()));
    }
    
    kdDebug() << "About to call kmenu" << endl;
    arg<< QPoint(QCursor::pos());	
    
    if (!dcop->call("kicker","kicker","popupKMenu(QPoint)",data,replytype,rdata,FALSE,-1))
    {
        kdWarning () << "**KBFX-APPLET-FATAL_ERROR:Could not send DCOP command\n";
    }
    
    this->setCursor(Qt::ArrowCursor);
    QCursor::setPos(ctmp);
    
    kdDebug() << "Kmenu Called" << endl;
}
