/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   sirajr@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KBFXCFGDIALOG_H
#define KBFXCFGDIALOG_H

#include "kbfxcfg_ui.h"

class KbfxCfgDialog: public KbfxConfigDialogWidget {
Q_OBJECT
private:
    QStringList mThemeFolderList;
    QStringList getThemes(const QString& themeFolder);
    bool isValidThemeFolder(const QString& themeFolder);
    QString getThemeProp(const QString& themeFile, const QString& key);
    bool applyTheme(const QString& themeName);
    void reloadThemeList();
    void loadDefaultTheme();
    void saveThemeConfig(QString& filename, QString& themeName);
    QMap<QString,QString> m_CurThemeConfig;
    QMap<QString,QString> getThemeConfig(const QString& themeFile);
public:
    KbfxCfgDialog(QWidget *parent = 0, const char *name = 0);
    void notifyApplet();
    //QString menutype;
public slots:     
    virtual void kcfg_Normal_urlSelected(const QString&);
    virtual void kcfg_Hover_urlSelected(const QString&);
    virtual void kcfg_Pressed_urlSelected(const QString&);
    virtual void btnResetNormal_clicked();
    virtual void btnResetHover_clicked();
    virtual void btnResetPressed_clicked(); 
    virtual void loadConfig();
    virtual void saveConfig();
    virtual void kcfg_ThemeBottom_urlSelected(const QString&);
    virtual void kcfg_ThemeBg_urlSelected(const QString&);
    virtual void kcfg_ThemeTop_urlSelected(const QString&);
    virtual void kcfg_ThemeMask_urlSelected(const QString&);
    virtual void kcfg_ThemeMainBg_urlSelected(const QString&);
    virtual void btnRefresh_clicked();
    virtual void btnApplyTheme_clicked();
    virtual void menuTypeSet(const QString &);
    virtual void btnSaveAs_clicked();
    virtual void btnSaveTheme_clicked();
    virtual void kcfg_ThemeList_activated(const QString&);
};
#endif
