#ifndef VISTALISTBOX_H
#define VISTALISTBOX_H


#include <qcombobox.h>
#include <qlistbox.h>
#include <qhbox.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qimage.h>
#include <qpainter.h>
#include <qstyle.h>
#include "../imagesource/listboxtile.xpm"
#include "../imagesource/listboxhover.xpm"
#include "../imagesource/menuright.xpm"


class VistaListBoxItem : public QListBoxItem 
{
public:
    VistaListBoxItem()
        : QListBoxItem()
    {
        setCustomHighlighting( TRUE );
	itemHeight=22;
	itemWidth= 106;
	type=0;
	_blocked = 0;
//        this->setMouseTracking(TRUE);

    }

	void VistaListBoxItem::setLabelText(QString * name);
	void setLabelIcon(QPixmap Normalicon);
	void setLabelIcon(QString normalIconPath);
	void setTilePixmap(QPixmap tile);
	void setTileHoverPixmap(QPixmap hovertile);
	void setHeight(int h);
	void setWidth(int w);
	void block(int b)
	{
	_blocked = b;
	}
	int isBocked()
	{
	return _blocked;
	}
	void setType(int t){ type = t;}
	void setExec(QString exec){application_exe = exec;}
	void setApplicationProperties(QString appname, QString exename,QString desktopfile);
	void setComment(QString comment) 
	{ 
	application_comment = comment;
	if (application_comment.length() > 22)
	{
	application_comment.setLength(22);
	application_comment += "...";
	}
	else if ( comment.length() == 0)
	{
	application_comment="...";
	}
	
	int len  = comment.length();
	
	for (int i = 0 ; i < len ; i++ )
	{
		
	}

	}
	QString * getText(){return text;}
	QString  getIcon(){return application_icon;}
	QString * getName() {return text;}
	QString  getComment() {return application_comment;}
	QString  getExec() { return application_exe;}

protected:
        //virtual bool eventFilter (QObject *, QEvent * e);
   //     virtual void enterEvent(QEvent * e); 
        virtual void paint( QPainter * );
//	virtual void mouseMoveEvent ( QMouseEvent * e );
        virtual int width( const QListBox* ) const { return itemWidth; }
        virtual int height( const QListBox* ) const 
	{
	if (listImageNormal.height() < 22 )
	return 22;
	else
	return listImageNormal.height(); 
	}



private:

	QPixmap iconPixmap;
	QPixmap listImageNormal;
	QPixmap listImageMouseOver;

	QString  application_icon;
	QString * application_name;
	QString  application_exe;
	QString * application_desktop_file;
	QString * application_time;
	QString  application_comment;
//TODO:to be fixed the types may change;
	QString * lastUsered;	
	QString * order;

	int itemHeight;
	int itemWidth;
	QString  * text;
	int type;
	int _blocked;
};

#endif
