/******************************************************************************
 *   Copyright (C) 2006 PhobosK <phobosk@mail.kbfx.org>                       *
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This package is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the             *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this package; if not, write to the Free Software              *
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA *
 ******************************************************************************/

#include "kbfxpushbutton.h"

KbfxPushButton::KbfxPushButton(QWidget *parent, const char *name)
  : KPushButton(parent, name)
{
  setText( "P R E V I E W" );
  setToggleButton(TRUE);
  setFocusPolicy(QWidget::NoFocus);
}

/* process hover events */
void KbfxPushButton::enterEvent (QEvent *mouseEnterEvent)
{
  if(this->state() == 0) this->setPixmap(ConfigInit().m_KbfxHoverButtonPath);
}

void KbfxPushButton::leaveEvent (QEvent * mouseLeaveEvent)
{
  if(this->state() == 2) this->setPixmap(ConfigInit().m_KbfxPressedButtonPath);
  if(this->state() == 0) this->setPixmap(ConfigInit().m_KbfxNormalButtonPath);
}

#include "kbfxpushbutton.moc"
