/*
 * ristypes.c
 *
 * Copyright (c) Chris Putnam 2003-5
 *
 * Program and source code released under the GPL
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fields.h"
#include "reftypes.h"
/*#include "is_ws.h"*/
	
static lookups generic[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTHDAY",     SIMPLE,  LEVEL_MAIN },
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_HOST }, 
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        SIMPLE,  LEVEL_MAIN }, /*user defined */
	{ "U2", "NOTES",        SIMPLE,  LEVEL_MAIN }, /* put in "notes" */
	{ "U3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U4", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U5", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M1", "NOTES",        SIMPLE,  LEVEL_MAIN }, /*misc */
	{ "M2", "NOTES",        SIMPLE,  LEVEL_MAIN }, /* put in "notes" */
	{ "M3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "  ", "TYPE|ARTICLE",           ALWAYS, LEVEL_MAIN }
};

static lookups article[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_HOST },
	{ "PY", "PARTYEAR",     DATE,    LEVEL_MAIN },
	{ "Y1", "PARTYEAR",     DATE,    LEVEL_MAIN },
	{ "Y2", "PARTMONTHDAY", SIMPLE,  LEVEL_MAIN },
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_HOST },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_HOST },
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U2", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U4", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U5", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M2", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "  ", "TYPE|ARTICLE",           ALWAYS, LEVEL_MAIN },
	{ "  ", "ISSUANCE|continuing",    ALWAYS, LEVEL_HOST },
	{ "  ", "RESOURCE|text",          ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE|periodical",       ALWAYS, LEVEL_HOST },
	{ "  ", "GENRE|academic journal", ALWAYS, LEVEL_HOST }
};

static lookups newsarticle[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_HOST },
	{ "PY", "PARTYEAR",     DATE,    LEVEL_MAIN },
	{ "Y1", "PARTYEAR",     DATE,    LEVEL_MAIN },
	{ "Y2", "PARTMONTHDAY", SIMPLE,  LEVEL_MAIN },
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_HOST },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_HOST },
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U2", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U4", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U5", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M2", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "  ", "TYPE|NEWSARTICLE",       ALWAYS, LEVEL_MAIN },
	{ "  ", "ISSUANCE|continuing",    ALWAYS, LEVEL_HOST },
	{ "  ", "RESOURCE|text",          ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE|newspaper",        ALWAYS, LEVEL_HOST }
};

static lookups book[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTHDAY",     SIMPLE,  LEVEL_MAIN }, 
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "JOURNAL",      SIMPLE,  LEVEL_MAIN },
	{ "JA", "JOURNAL",      SIMPLE,  LEVEL_MAIN },
	{ "JF", "JOURNAL",      SIMPLE,  LEVEL_MAIN },
	{ "J1", "JOURNAL",      SIMPLE,  LEVEL_MAIN },
	{ "J2", "JOURNAL",      SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_MAIN },  /* BOOKTITLE */
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U2", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U4", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U5", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M2", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "  ", "ISSUANCE|monographic",  ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE|book",    ALWAYS, LEVEL_MAIN },
	{ "  ", "RESOURCE|text", ALWAYS, LEVEL_MAIN }
};

static lookups inbook[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_HOST },
	{ "PY", "YEAR",         DATE,    LEVEL_HOST },
	{ "Y1", "YEAR",         DATE,    LEVEL_HOST },
	{ "Y2", "MONTHDAY",     SIMPLE,  LEVEL_HOST }, 
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_HOST },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_HOST },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_HOST },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_HOST },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_HOST },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_HOST },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_HOST }, /* BOOKTITLE */
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_HOST },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U2", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U4", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U5", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M2", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "  ", "GENRE|book",    ALWAYS, LEVEL_HOST },
	{ "  ", "ISSUANCE|monographic",  ALWAYS, LEVEL_HOST },
	{ "  ", "RESOURCE|text", ALWAYS, LEVEL_MAIN }
};

static lookups conference[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_HOST },
	{ "Y1", "YEAR",         DATE,    LEVEL_HOST },
	{ "Y2", "MONTHDAY",     SIMPLE,  LEVEL_HOST }, 
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_HOST },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_HOST }, 
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_HOST },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U2", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U4", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U5", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M2", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "  ", "TYPE|CONFERENCE",       ALWAYS, LEVEL_MAIN },
	{ "  ", "RESOURCE|text",                ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE|conference publication", ALWAYS, LEVEL_HOST }
};

static lookups statute[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTHDAY",     SIMPLE,  LEVEL_MAIN }, 
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_HOST },  /* book title */
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U2", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U4", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U5", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M2", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "  ", "TYPE|STATUTE",          ALWAYS, LEVEL_MAIN },
	{ "  ", "RESOURCE|text",         ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE|legislation",     ALWAYS, LEVEL_MAIN }
};

static lookups hearing[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTHDAY",     SIMPLE,  LEVEL_MAIN }, 
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES }, /* series title */
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_MAIN }, 
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U2", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U4", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U5", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M2", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "  ", "TYPE|HEARING",          ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE|hearing",         ALWAYS, LEVEL_MAIN }
};

static lookups cases[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "AUTHOR",       PERSON,  LEVEL_HOST },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_SERIES }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTHDAY",     SIMPLE,  LEVEL_MAIN }, 
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_MAIN }, 
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U2", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U4", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U5", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M2", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "  ", "TYPE|CASE",          ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE|legal case and case notes", ALWAYS, LEVEL_MAIN }
};

static lookups communication[] = {
	{ "AU", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A1", "AUTHOR",       PERSON,  LEVEL_MAIN },
	{ "A2", "RECIPIENT",    PERSON,  LEVEL_MAIN },
	{ "A3", "AUTHOR",       PERSON,  LEVEL_HOST }, 
	{ "ED", "EDITOR",       PERSON,  LEVEL_MAIN },
	{ "PY", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y1", "YEAR",         DATE,    LEVEL_MAIN },
	{ "Y2", "MONTHDAY",     SIMPLE,  LEVEL_MAIN },
	{ "SN", "SERIALNUMBER", SERIALNO,LEVEL_MAIN },
	{ "TI", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T1", "TITLE",        TITLE,   LEVEL_MAIN },
	{ "T2", "SHORTTITLE",   SIMPLE,  LEVEL_HOST },
	{ "T3", "TITLE",        SIMPLE,  LEVEL_SERIES },
	{ "JO", "TITLE",        SIMPLE,  LEVEL_HOST }, /* JOURNAL */
	{ "JA", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "JF", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J1", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "J2", "TITLE",        SIMPLE,  LEVEL_HOST },
	{ "VL", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "VO", "VOLUME",       SIMPLE,  LEVEL_MAIN },
	{ "IS", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "CP", "ISSUE",        SIMPLE,  LEVEL_MAIN },
	{ "SP", "PAGESTART",    SIMPLE,  LEVEL_MAIN },
	{ "EP", "PAGEEND",      SIMPLE,  LEVEL_MAIN },
	{ "AB", "ABSTRACT",     SIMPLE,  LEVEL_MAIN },
	{ "N1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "N2", "ABSTRACT",     SIMPLE,  LEVEL_MAIN }, 
	{ "KW", "KEYWORD",      SIMPLE,  LEVEL_MAIN },
	{ "PB", "PUBLISHER",    SIMPLE,  LEVEL_MAIN },
	{ "BT", "TITLE",        SIMPLE,  LEVEL_MAIN }, 
	{ "CT", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "AD", "AUTHORADDRESS",SIMPLE,  LEVEL_MAIN },
	{ "CY", "ADDRESS",      SIMPLE,  LEVEL_MAIN },
	{ "RP", "REPRINTSTATUS",SIMPLE,  LEVEL_MAIN },
	{ "UR", "URL",          SIMPLE,  LEVEL_MAIN },
	{ "ID", "REFNUM",       SIMPLE,  LEVEL_MAIN },
	{ "U1", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U2", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U4", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "U5", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M1", "GENRE",        SIMPLE,  LEVEL_MAIN },
	{ "M2", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "M3", "NOTES",        SIMPLE,  LEVEL_MAIN },
	{ "  ", "TYPE|ARTICLE",           ALWAYS, LEVEL_MAIN },
	{ "  ", "GENRE|communication",    ALWAYS, LEVEL_MAIN }
};

variants ris_all[] = {
	{ "STD",  &(generic[0]), sizeof(generic)/sizeof(lookups)},
	{ "GEN",  &(generic[0]), sizeof(generic)/sizeof(lookups)},
	{ "JOUR", &(article[0]), sizeof(article)/sizeof(lookups)},
	{ "BOOK", &(book[0]), sizeof(book)/sizeof(lookups)},
	{ "CHAP", &(inbook[0]), sizeof(inbook)/sizeof(lookups)},
	{ "CONF", &(conference[0]), sizeof(conference)/sizeof(lookups)},
	{ "STAT", &(statute[0]), sizeof(statute)/sizeof(lookups)},
	{ "HEAR", &(hearing[0]), sizeof(hearing)/sizeof(lookups)},
	{ "CASE", &(cases[0]), sizeof(cases)/sizeof(lookups)},
	{ "NEWS", &(newsarticle[0]), sizeof(newsarticle)/sizeof(lookups)},
	{ "MPCT", &(generic[0]), sizeof(generic)/sizeof(lookups)},
	{ "PCOMM", &(communication[0]), sizeof(communication)/sizeof(lookups)},
	{ "PAMP", &(generic[0]), sizeof(generic)/sizeof(lookups)},
	{ "ELEC", &(generic[0]), sizeof(generic)/sizeof(lookups)}
};

int ris_nall = sizeof( ris_all ) / sizeof( variants );

#ifdef NOCOMPILE
int
get_reftype( char *p, long refnum )
{
	int i;
	while ( is_ws( *p ) ) p++;
	for ( i=0; i<nall; ++i ) 
		if ( !strncasecmp( all[i].type, p, strlen(all[i].type) ) )
			return i;
	fprintf( stderr, "Warning: Did not recognize '%s' of refnum %ld, defaulting to generic.\n",
			p, refnum );
	return 0;
}
#endif
