/***************************************************************************
                          kbiblistviewitem.cpp  -  description
                             -------------------
    begin                : Wed May 28 2003
    copyright            : (C) 2003 by Thach Nguyen
    email                : thach@dragon.thach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbiblistviewitem.h"
#include "kbiblistview.h"
#include "kbib.h"
#include "kbibdoc.h"
#include <kiconloader.h>
#include <qdragobject.h>

KBibListViewItem::KBibListViewItem(QListView *parent, KBibDoc *doc, BibEntry * item, QStringList displayFields, int numAuthorsDisplayed) : KListViewItem(parent)
{
        bibItem = item;

		updateItemContent(doc, displayFields, numAuthorsDisplayed);
}
KBibListViewItem::~KBibListViewItem()
{
}


void  KBibListViewItem::updateItemContent(KBibDoc *doc, QStringList displayFields, int numAuthorsDisplayed)
{
	
	QString fieldName;
	QString field;
	int i = 0;
	QStringList::iterator it;
	
	for (it =  displayFields.begin(); it != displayFields.end(); it++) {

		fieldName = *it;
		if (fieldName == QString::fromLatin1("citation key") ){
			field = QString(bibItem->getKey());
			QPixmap pix;
			if (bibItem->getField("lockkey") == QString::fromLatin1("Y")){
				pix = KGlobal::iconLoader()->loadIcon(QString::fromLatin1("lock"), KIcon::Small);	
			}
			else
				pix = KGlobal::iconLoader()->loadIcon(QString::fromLatin1("unlock"), KIcon::Small);
			setPixmap(i, pix);
		}
		else{
			field = (doc->getEntryList()->getFieldText(bibItem, fieldName) ).simplifyWhiteSpace();
			setPixmap(i, 0);
		}
		
		if (fieldName == QString::fromLatin1("author") || fieldName == QString::fromLatin1("editor") )
			field = reformatAuthors(field, numAuthorsDisplayed);
		setText(i, field);
		i++;
	
	}
	
}


BibEntry* KBibListViewItem::getBibEntry()
{
        return bibItem;
}

/** No descriptions */
void KBibListViewItem::setBibEntry(BibEntry * item)
{
        bibItem = item;
}
