/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef SETTINGS_H
#define SETTINGS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qstringlist.h>

#include <kcompletion.h>

#include <file.h>
#include <fieldlineedit.h>
#include <fileexporterbibtex.h>
#include <fileexporterexternal.h>
#include <entryfield.h>
#include <entry.h>

class KConfig;
class KStandardDirs;
class KURL;
class QString;
class QRegExp;
class QChar;
class QFont;
class BibTeX::Element;

namespace KBibTeX
{
    class Settings
    {
    public:
        struct SearchURL
        {
            QString description;
            QString url;
            bool includeAuthor;
        };

        struct UserDefinedInputFields
        {
            QString name;
            QString label;
            FieldLineEdit::InputType inputType;
        };

        static Settings* self( BibTeX::File *bibtexFile = NULL );

        void load( KConfig * config );
        void save( KConfig * config );

        static QString fieldTypeToI18NString( const BibTeX::EntryField::FieldType fieldType );
        static QString entryTypeToI18NString( const BibTeX::Entry::EntryType entryType );

        static KURL doiURL( const QString& doiText );
        static bool kpsewhich( const QString& filename );
        static KURL locateFile( const QString& filename, const QString& bibTeXFileName = QString::null, QWidget *window = NULL );
        KURL locateFile( const QString& filename, QWidget *window = NULL );

#ifdef HAVE_YAZ
        void z3950clearAll();
        void z3950loadDefault();
        void z3950loadUser( KConfig * config );
        void z3950saveUser( KConfig *config );
        typedef struct Z3950Server_
        {
            QString charset, database, host, locale, name, syntax, user, password;
            int port;
        } Z3950Server;
        QMap<QString, Z3950Server> z3950_ServerList;
#endif // HAVE_YAZ

        enum DragAction {COPYREFERENCE = 1, COPYBIBTEX = 2};

        // FileIO section
        QString fileIO_Encoding;
        QString fileIO_ExportLanguage;
        QString fileIO_ExportBibliographyStyle;
        QChar fileIO_BibtexStringOpenDelimiter;
        QChar fileIO_BibtexStringCloseDelimiter;
        BibTeX::FileExporterBibTeX::KeywordCasing fileIO_KeywordCasing;
        BibTeX::FileExporterExternal::Exporter fileIO_ExporterHTML;
        bool fileIO_EmbedFiles;
        bool fileIO_EnclosingCurlyBrackets;
        bool fileIO_useBibUtils;
        QString fileIO_bib2db5BasePath;
        QString fileIO_bib2db5ClassPath;
        int fileIO_NumberOfBackups;

        bool updateBib2Db5ClassPath( const QString& newBasePath, bool testOnly = false );

        // Editing section
        bool editing_SearchBarClearField;
        bool editing_EnableAllFields;
        int editing_MainListDoubleClickAction;
        int editing_MainListSortingColumn;
        int editing_MainListSortingOrder;
        QStringList editing_FilterHistory;
        bool editing_ShowMacros;
        bool editing_ShowComments;
        QValueList<int> editing_MainListColumnsWidth;
        QValueList<int> editing_MainListColumnsIndex;
        QValueList<int> editing_HorSplitterSizes;
        QValueList<int> editing_VertSplitterSizes;
        QFont editing_SpecialFont;
        bool editing_UseSpecialFont;
        bool editing_FirstNameFirst;
        QStringList editing_DocumentSearchPaths;
        DragAction editing_DragAction;
        int editing_findDuplicatesSensitivity;

        // SearchURLs section
        QValueList<SearchURL*> searchURLs;

        // UserDefinedInputFields section
        QValueList<UserDefinedInputFields*> userDefinedInputFields;

        // External section
        QString external_XSLTStylesheetHTML;
        bool external_bibconvAvailable;
        bool external_bibtex2htmlAvailable;
        bool external_bib2xhtmlAvailable;
        bool external_latex2rtfAvailable;
        bool external_xml2bibAvailable;
        bool external_end2xmlAvailable;
        bool external_ris2xmlAvailable;

        // Id Suggestions
        QStringList idSuggestions_formatStrList;
        int idSuggestions_default;
        bool idSuggestions_forceDefault;

        // Auto-completion for user fields (non-persistant)
        void addToCompletion( BibTeX::File *file );
        void addToCompletion( BibTeX::Element *element );
        void addToCompletion( BibTeX::Value *value, BibTeX::EntryField::FieldType fieldType );
        KCompletion* completion( BibTeX::EntryField::FieldType fieldType );
        KCompletion* completionMacro;

        // Keyword list
        QStringList keyword_GlobalList;

        // Online Database Search;
        int webQuery_LastEngine;
        QString webQuery_LastSearchTerm;
        int webQuery_LastNumberOfResults;
        bool webQuery_ImportAll;

        // Current BibTeX file
        BibTeX::File *currentBibTeXFile;

        void restoreDefaultSearchURLs();

        QString detectLyXInPipe();

        // web query history/default values
        QString getWebQueryDefault( const QString &key );
        void setWebQueryDefault( const QString &key, const QString& value );

        // characters that do match this regexp are
        // not allowed in entry ids or macro keys
        static const QRegExp noIdChars;

        /** Create backup of file as specified in fileIO_NumberOfBackups */
        bool createBackup( const KURL &url, QWidget *window=NULL );

    private:
        static Settings* staticSettings;
        KCompletion **m_completion;
        static QStringList m_lyxRcFileNames;

        QMap<QString, QString> m_webQueryDefaults;

        Settings();
        ~Settings();

        bool checkExternalToolAvailable( const QString &binary );
        void checkExternalToolsAvailable();

        int completionFieldTypeToIndex( BibTeX::EntryField::FieldType fieldType );
    };
}

#endif
