/***************************************************************************
*   Copyright (C) 2004-2007 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include <qwidget.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <qpushbutton.h>

#include <klocale.h>
#include <kcombobox.h>
#include <kiconloader.h>
#include <kurllabel.h>
#include <klineedit.h>
#include <kapplication.h>

#include "webquery.h"

namespace KBibTeX
{

    WebQuery::WebQuery( QWidget *parent, const char *name )
            : QObject( parent, name )
    {
        // nothing
    }

    WebQuery::~WebQuery()
    {
        // nothing
    }

    WebQueryWizard::WebQueryWizard( const QString &caption, const QString &disclaimer, const QString&disclainerURL, bool showListOfMirrors, bool showNumberOfResults, QWidget* parent, const char* name ) : KDialogBase( parent, name, TRUE, "Import", Ok | Cancel, Ok, TRUE ), m_bibtexFile( NULL )
    {
        setCaption( caption );
        setPlainCaption( caption );
        setupGUI( disclaimer, disclainerURL, showListOfMirrors, showNumberOfResults );
    }

    WebQueryWizard::~WebQueryWizard()
    {
        // nothing
    }

    BibTeX::File *WebQueryWizard::result()
    {
        return m_bibtexFile;
    }

    void WebQueryWizard::listViewResultsSelectionChanged( )
    {
        QListViewItemIterator it( m_listViewResults, QListViewItemIterator::Selected );

        enableButtonOK( it.current() != NULL );
    }

    void WebQueryWizard::setupGUI( const QString &disclaimer, const QString&disclainerURL, bool showListOfMirrors, bool showNumberOfResults )
    {
        QWidget * mainWidget = new QWidget( this );
        mainWidget->setMinimumSize( 640, 256 );
        QVBoxLayout *verticalLayout = new QVBoxLayout( mainWidget, 0, KDialog::spacingHint() );
        m_toolbarContainer = new QWidget( mainWidget );
        verticalLayout->addWidget( m_toolbarContainer );
        QHBoxLayout *horizontalLayout = new QHBoxLayout( m_toolbarContainer, 0, KDialog::spacingHint() );

        if ( showListOfMirrors )
        {
            QLabel *label = new QLabel( i18n( "&Mirrors:" ), m_toolbarContainer );
            horizontalLayout->addWidget( label );
            m_comboBoxMirrors = new KComboBox( FALSE, m_toolbarContainer, "m_comboBoxMirrors" );
            horizontalLayout->addWidget( m_comboBoxMirrors );
            label->setBuddy( m_comboBoxMirrors );
            horizontalLayout->addSpacing( KDialog::spacingHint() * 2 );
        }
        else
            m_comboBoxMirrors = NULL;

        QLabel *label = new QLabel( i18n( "&Query string:" ), m_toolbarContainer );
        horizontalLayout->addWidget( label );
        m_lineEditQuery = new KLineEdit( m_toolbarContainer );
        horizontalLayout->addWidget( m_lineEditQuery );
        label->setBuddy( m_lineEditQuery );
        horizontalLayout->addSpacing( KDialog::spacingHint() * 2 );

        if ( showNumberOfResults )
        {
            label = new QLabel( i18n( "&Number of results:" ), m_toolbarContainer );
            horizontalLayout->addWidget( label );
            m_spinBoxMaxHits = new QSpinBox( 5, 5000, 1, m_toolbarContainer );
            m_spinBoxMaxHits->setValue( 50 );
            horizontalLayout->addWidget( m_spinBoxMaxHits );
            label->setBuddy( m_spinBoxMaxHits );
            horizontalLayout->addSpacing( KDialog::spacingHint() * 2 );
        }
        else
            m_spinBoxMaxHits = NULL;

        m_pushButtonSearch = new QPushButton( i18n( "&Search" ), m_toolbarContainer );
        horizontalLayout->addWidget( m_pushButtonSearch );
        m_pushButtonSearch->setIconSet( QIconSet( SmallIcon( "find" ) ) );

        m_listViewResults = new QListView( mainWidget );
        m_listViewResults->addColumn( i18n( "Year" ), 64 );
        m_listViewResults->addColumn( i18n( "Author" ), 128 );
        m_listViewResults->addColumn( i18n( "Title" ), 512 );
        m_listViewResults->setAllColumnsShowFocus( TRUE );
        m_listViewResults->setSelectionMode( QListView::Extended );
        verticalLayout->addWidget( m_listViewResults );

        KURLLabel *disclaimerLabel = new KURLLabel( mainWidget );
        disclaimerLabel->setText( disclaimer );
        disclaimerLabel->setURL( disclainerURL );
        verticalLayout->addWidget( disclaimerLabel );

        m_lineEditQuery->setFocus();
        setMainWidget( mainWidget );
        setButtonOK( KGuiItem( i18n( "&Import" ), "import", i18n( "Import selected items" ) ) );
        enableButtonOK( FALSE );

        connect( disclaimerLabel, SIGNAL( leftClickedURL( const QString& ) ), kapp, SLOT( invokeBrowser( const QString& ) ) );
        connect( m_listViewResults, SIGNAL( selectionChanged( ) ), this, SLOT( listViewResultsSelectionChanged( ) ) );
        connect( m_listViewResults, SIGNAL( clicked( QListViewItem* ) ), this, SLOT( listViewResultsSelectionChanged( ) ) );
        connect( m_pushButtonSearch, SIGNAL( clicked() ), this, SLOT( startSearch() ) );
        connect( m_lineEditQuery, SIGNAL( returnPressed() ), this, SLOT( startSearch() ) );
    }

    void WebQueryWizard::accept()
    {
        m_bibtexFile = new BibTeX::File();
        for ( QListViewItemIterator it( m_listViewResults, QListViewItemIterator::Selected ); it.current(); ++it )
        {
            ResultsListViewItem *item = dynamic_cast<ResultsListViewItem*>( *it );
            if ( item != NULL )
                m_bibtexFile->appendElement( item->entry()->clone() );
        }

        KDialogBase::accept();
    }

    ResultsListViewItem::ResultsListViewItem( QListView * parent, BibTeX::Entry * entry ) : QListViewItem( parent ), m_entry( entry )
    {
        BibTeX::EntryField * field = entry->getField( BibTeX::EntryField::ftTitle );
        if ( field != NULL && field->value() != NULL )
            setText( 2, field ->value() ->text() );
        field = entry->getField( BibTeX::EntryField::ftAuthor );
        if ( field != NULL && field->value() != NULL )
        {
            BibTeX::PersonContainer* personContainer = dynamic_cast<BibTeX::PersonContainer*>( field->value()->items.first() );
            if ( personContainer != NULL )
            {
                QStringList authors;
                QValueList<BibTeX::Person*> list = personContainer->persons;
                for ( QValueList<BibTeX::Person*>::ConstIterator it = list.begin(); it != list.end(); ++it )
                    authors.append(( *it ) ->text() );
                setText( 1, authors.join( " and " ) );
            }
            else setText( 1, field ->value() ->text() );
        }
        field = entry->getField( BibTeX::EntryField::ftYear );
        if ( field != NULL && field->value() != NULL )
            setText( 0, field ->value() ->text() );
    }

    ResultsListViewItem::~ResultsListViewItem()
    {
        if ( m_entry != NULL )
            delete m_entry;
    }

    BibTeX::Entry* ResultsListViewItem::entry()
    {
        return m_entry;
    }

}
#include "webquery.moc"
