/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef KBIBTEXWEBQUERY_H
#define KBIBTEXWEBQUERY_H

#include <qobject.h>
#include <qstring.h>
#include <qlistview.h>

#include <kdialogbase.h>

#include "file.h"
#include "entry.h"

class QWidget;
class QListView;
class QSpinBox;
class KLineEdit;
class KComboBox;

namespace KBibTeX
{

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQuery : public QObject
    {
        Q_OBJECT
    public:
        WebQuery( QWidget *parent = 0, const char *name = 0 );
        ~WebQuery();

        virtual BibTeX::File* query( ) = 0;

        virtual QString title() = 0;
        virtual int uniqueId() = 0;

    };

    class WebQueryWizard: public KDialogBase
    {
        Q_OBJECT
    public:
        WebQueryWizard( const QString &caption, const QString &disclaimer, const QString&disclainerURL, bool showListOfMirrors, bool showNumberOfResults, QWidget* parent, const char* name = 0 );
        ~WebQueryWizard();

        BibTeX::File *result();

    public slots:
        void accept();

    protected slots:
        void virtual startSearch() = 0;

    private slots:
        void listViewResultsSelectionChanged( );

    protected:
        BibTeX::File *m_bibtexFile;
        QWidget *m_toolbarContainer;
        KComboBox *m_comboBoxMirrors;
        QListView *m_listViewResults;
        KLineEdit *m_lineEditQuery;
        QSpinBox *m_spinBoxMaxHits;

    private:
        QPushButton *m_pushButtonSearch;

        void setupGUI( const QString &disclaimer, const QString&disclainerURL, bool showListOfMirrors, bool showNumberOfResults );
    };

    class ResultsListViewItem: public QListViewItem
    {
    public:
        ResultsListViewItem( QListView * parent, BibTeX::Entry *entry );
        ~ResultsListViewItem();

        BibTeX::Entry* entry();
    private:
        BibTeX::Entry *m_entry;
    };
}

#endif
