/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "kbloggerblog.h"

#include <kwallet.h>
#include <kicon.h>
#include <kmimetype.h>
#include <kdebug.h>

namespace KBlogger
{

KBloggerBlog::KBloggerBlog(): mWallet(0)
{
    mWallet = KWallet::Wallet::openWallet( "kdewallet", 0 );
    if ( mWallet ) {
        mWallet->setFolder( "kblogger" );
        kDebug() << "Wallet successfully opened.";
    }

}

KBloggerBlog::~KBloggerBlog()
{}

void KBloggerBlog::setBlogname( const QString& blogname )
{
    mBlogname = blogname;
}

QString KBloggerBlog::blogname()
{
    return mBlogname;
}

void KBloggerBlog::setUrl( const QString& url )
{
    mUrl = url;
}

KUrl KBloggerBlog::url()
{
    return mUrl;
}

void KBloggerBlog::setUsername( const QString& username )
{
    mUsername = username;
}

QString KBloggerBlog::username()
{
    return mUsername;
}

void KBloggerBlog::setFullName( const QString& fullName )
{
    mFullName = fullName;
}

QString KBloggerBlog::fullName()
{
    return mFullName;
}

QString KBloggerBlog::password()
{
    kDebug();
    QString url = mUrl.url();
    if( url.isEmpty() || mUsername.isEmpty() )
      return QString();
//     Q_ASSERT( !url.isEmpty() ); // asserting is too hard for buggy profiles
//     Q_ASSERT( !mUsername.isEmpty() );
    if (!mWallet ) return QString();
    QString buffer;
    mWallet->readPassword( url + '_' + mUsername, buffer );
    return buffer;
}

void KBloggerBlog::setApi( Backend::api_type api)
{
    mApi = api;
}

Backend::api_type KBloggerBlog::api()
{
    return mApi;
}

void KBloggerBlog::setBlogId( const QString& id )
{
    mBlogId = id;
}

QString KBloggerBlog::blogId()
{
    return mBlogId;
}

KIcon KBloggerBlog::icon()
{
    QString iconName;
    iconName = KMimeType::iconNameForUrl(mUrl);
    kDebug() << "icon=" << iconName;
    if ( iconName == "www" )
        iconName = "kontact-news";
    return KIcon( iconName );
}

} //namespace
