/***************************************************************************
 *   Copyright (C) 2005 by Christian Weilbach   *
 *   christian_weilbach@web.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qsize.h>
#include <qpixmap.h>

#include <kaboutdata.h>
#include <kaboutapplication.h>
#include <kaboutdialog.h>
#include <kglobal.h>
#include <klocale.h>
#include <kconfigdialog.h>
#include <kapplication.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include <kstandarddirs.h>
#include <kurl.h>
#include <kio/job.h>

#include "kblogger.h"
#include "kbloggerconfigdialog.h"
#include "kbloggerconfig.h"
#include "kbloggereditor.h"
#include "API_Blogger.h"
#include "API_MetaWeblog.h"



KBlogger::KBlogger(const QString& configFile, Type type, int actions, QWidget *parent, const char *name)
        : KPanelApplet(configFile, type, actions, parent, name)//, mButton( this )
{
	updateBackend();

	// create the applet-widget
	kdDebug() << "creating applet-widget" << endl;
	QVBoxLayout *appletlay = new QVBoxLayout(this);
	QPushButton *blogbt = new QPushButton( i18n("blog"),this );
	appletlay->addWidget(blogbt);
	if (!parent)
		setBackgroundMode(X11ParentRelative);

	// initialize configuration
	kdDebug() << "creating KConfigDialog"  <<  endl;
	configdialog = new KConfigDialog( this, "settings", KBloggerConfig::self(), KDialogBase::Plain );
	configwd = new KBloggerConfigDialog();
	configdialog->addPage( configwd, i18n("KBlogger settings"), "KBlogger settings" );
	configdialog->setInitialSize( QSize( 520, 300 ), false ); // FIXME

	connect(blogbt,SIGNAL(clicked()),
		this,SLOT(editor()));

}


KBlogger::~KBlogger()
{}

void KBlogger::editor(){
	// create the editor
	kdDebug() << "creating the editor-widget" << endl;
	KBloggerEditor *editor = new KBloggerEditor( this->backend );

	connect(editor,SIGNAL(sendSignal(QString,QString,QString,bool)),
		this,SLOT(sendSlot(QString,QString,QString,bool)));
}

void KBlogger::updateBackend(){
	// delete old backend, if available
// 	delete backend; // FIXME memory leak

	kdDebug() << "creating KURL" << endl;
	KURL mServerUrl(  KBloggerConfig::url() );

	// create the backend
	kdDebug() << "API type " << KBloggerConfig::type() << endl;
	switch( KBloggerConfig::type() ){
		case 0: // BloggerAPI
		kdDebug() << "creating APIBlogger( '"<< KBloggerConfig::url() << "' )" << endl;
		backend = new KBlog::APIBlogger( mServerUrl ); 
		backend->setAppID( "0123456789ABCDEF" ); // id not needed anymore
		break;

		case 1: // MetaWeblog
		backend = new KBlog::APIMetaWeblog( mServerUrl ); 
		break;

		default:
		kdDebug() << "This should never happen. API type not found." << endl;
		return;
		break;
	}
	backend->setUsername( KBloggerConfig::user() );
	backend->setPassword( KBloggerConfig::password() );
}

void KBlogger::about()
{
	kdDebug() << "creating KAboutData" << endl;
	KAboutData data("KBlogger", "kblogger", 
				"0.5", "A kicker applet for blogging.", 
				1, 0, 0, "http://kblogger.pwsp.net", "christian_weilbach@web.de");
	data.addAuthor ("Christian Weilbach", "Main developer", 
				"christian_weilbach@web.de", "whiletaker.homeip.net");
	data.addAuthor ( "Harald Sitter", "Documentation and Support" );
	data.addAuthor ( "Kenneth Wimer", "Icon designer" );
	KAboutApplication aboutdialog( &data );
	aboutdialog.exec();
}


void KBlogger::help()
{
	kapp->invokeHelp(QString::null, QString::fromLatin1("kblogger"));
}


void KBlogger::preferences()
{
	configdialog->show();
}

int KBlogger::widthForHeight(int height) const
{
	return 70;
}

int KBlogger::heightForWidth(int width) const
{ 
	return 20;
}

void KBlogger::resizeEvent(QResizeEvent *e)
{}

void KBlogger::sendSlot(QString title,QString text, QString category, bool publish)
{
	kdDebug() << "sendToBlog" << endl;

	kdDebug() << "creating BlogPosting()" << endl;
	KBlog::BlogPosting *posting = new KBlog::BlogPosting();
	posting->setBlogID( KBloggerConfig::blogId() );
	posting->setTitle( title );
	posting->setContent( text );
	posting->setPublish( publish );
	posting->setCategory( category );

	kdDebug() << "creating backend->createUploadNewJob( ... )" << endl;
	KIO::TransferJob* job = backend->createUploadNewJob( posting );
	if( backend->interpretUploadJob( job )==false ) 
	{
		kdDebug() << "got a backend error" << endl;
	}
}


extern "C"
{
	KPanelApplet* init( QWidget *parent, const QString& configFile)
	{
		KGlobal::locale()->insertCatalogue("KBlogger");
		return new KBlogger(configFile, KPanelApplet::Normal,
				KPanelApplet::About | KPanelApplet::Help | KPanelApplet::Preferences,
				parent, "KBlogger");
	}
}
