/* This file is part of the KDE project
   Copyright (c) 2006 Christian Weilbach <christian at whiletaker.homeip.net>
   Copyright (c) 2004 Kevin Ottens <ervin ipsquad net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/


#include "kbloggerbutton.h"
#include "kbloggermenu.h"


#include <qpopupmenu.h>
#include <qtooltip.h>

#include <klocale.h>
#include <krun.h>
#include <kpopupmenu.h>
#include <kdebug.h>

#include <kio/netaccess.h>

#include <konq_operations.h>
#include <konq_popupmenu.h>
#if KDE_IS_VERSION(3,5,0)

KBloggerButton::KBloggerButton(KBlogger *parent )
	: PanelButton(dynamic_cast<QWidget*>(parent), 0), mActions(this, this),
	  m_parent( parent ),
	  mFileItem(KFileItem::Unknown, KFileItem::Unknown, "trash:/")
{
// 	KIO::UDSEntry entry;
// 	KIO::NetAccess::stat("trash:/", entry, 0L);
// 	mFileItem.assign(KFileItem(entry, "trash:/"));

	KAction *a = KStdAction::paste(this, SLOT(slotPaste()),
	                               &mActions, "paste");
	a->setShortcut(0);

	move(0, 0);
	resize(20, 20);

	setTitle(i18n("KBlogger"));
	QToolTip::add(this, i18n("An applet for blogging."));
	setIcon( "kblogger" );

	setAcceptDrops(true);

	// Activate this code only if we find a way to have both an
	// action and a popup menu for the same kicker button
	connect(this, SIGNAL(clicked()), this, SLOT(slotClicked()));

// 	setPopup(new QPopupMenu());
}

KBloggerButton::~KBloggerButton()
{
}

// void KBloggerButton::setItemCount(int count)
// {
//     if (count==0)
//     {
//         setIcon( "trashcan_empty" );
//         QToolTip::add(this, i18n("Empty"));
//     }
//     else
//     {
//         setIcon( "trashcan_full" );
//         QToolTip::add(this, i18n("One item", "%n items", count));
//     }
// }


// Activate this code only if we find a way to have both an
// action and a popup menu for the same kicker button

void KBloggerButton::slotClicked()
{
// 	mFileItem.run();
	m_parent->editorSlot();
}


void KBloggerButton::slotPaste()
{
// 	m_parent->upload( mFileItem.url());	
}

void KBloggerButton::dragEnterEvent(QDragEnterEvent* e)
{
	e->accept(true);
}

void KBloggerButton::dropEvent(QDropEvent *e)
{
	kdDebug() << "encodedData( \"text/plain\" ) "<< QString( e->encodedData( "text/plain" ) ) << endl;
	m_parent->uploadSlot( QString( e->encodedData( "text/plain" ) ) );
}

QString KBloggerButton::tileName()
{
// 	return mFileItem.name();
}

void KBloggerButton::setPanelPosition(KPanelApplet::Position position)
{
	switch(position)
	{
	case KPanelApplet::pBottom:
		setPopupDirection(KPanelApplet::Up);
		break;
	case KPanelApplet::pTop:
		setPopupDirection(KPanelApplet::Down);
		break;
	case KPanelApplet::pRight:
		setPopupDirection(KPanelApplet::Left);
		break;
	case KPanelApplet::pLeft:
		setPopupDirection(KPanelApplet::Right);
		break;
	}
}

#include "kbloggerbutton.moc"
#endif