/***************************************************************************
 *   Copyright (C) 2005 by Christian Weilbach   *
 *   christian_weilbach@web.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KBLOGGEREDITOR_H
#define KBLOGGEREDITOR_H

#include "kbloggereditorblank.h"
#include "kbloggerlinkdialog.h"
#include "API_Blog.h"

class KBloggerEditor : public KBloggerEditorBlank
{
	Q_OBJECT

public:
	KBloggerEditor( KBlog::APIBlog* backend, int postid = -1, QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~KBloggerEditor();
	/*$PUBLIC_FUNCTIONS$*/

public slots:
	/*$PUBLIC_SLOTS$*/
	virtual void sendSlot();
	virtual void getCategoriesSlot( const QString& name, const QString& description );

protected:
	/*$PROTECTED_FUNCTIONS$*/

protected slots:
	/*$PROTECTED_SLOTS$*/
private:
	KBlog::APIBlog* m_backend;
	int m_postid;
	QString m_editCategory;
	KBloggerLinkDialog *m_linkDialog;
private slots:
	void loadPostSlot(KBlog::BlogPosting &posting);
	void disconnectCategoriesSlot();
	void toggleItalic();
	void toggleBold();
	void linkDialogSlot();
	void addHtmlLink(QString, QString);
	void closeSignal( const int );
};

#endif

