/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>
   Copyright (C) 2008 Christian Weilbach <christian_weilbach@web.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef BLOG_JOB_P_H
#define BLOG_JOB_P_H

#include "blogjob.h"

#include <kurl.h>

namespace KBlogger{

class BlogJobPrivate
{
public Q_SLOTS:
    void slotExitSuccess();
    void slotExitError( KBlog::Blog::ErrorType type, const QString& message);
    void slotListBlogs( const QList<QMap<QString,QString> >&);
    void slotListRecentPosts( const QList<KBlog::BlogPost>& posts);
    void slotListCategories( const QList<QMap<QString, QString> >& categories );
    void slotCreatePost( KBlog::BlogPost *post);
    void slotRemovePost( KBlog::BlogPost *post);
    void slotFetchPost( KBlog::BlogPost *post);
    void slotModifyPost( KBlog::BlogPost *post);
    void slotCreateMedia( KBlog::BlogMedia* media);

public:
    BlogJob *q_ptr;
    BlogJobPrivate();
    virtual ~BlogJobPrivate();
    void createKBlog(BlogJob::BlogAPI);
    bool setKBlogAuthentication();

    BlogJob::BlogAction mAction;
    BlogJob::BlogAPI mApi;
    QVariant mArg;
    KBlog::Blog* mKBlog;
    QList<QVariant> mResults;
    QString mWaitMessage;
    QString mUsername;
    QString mPassword;
    QString mBlogId;
    KUrl mUrl;
};

}

#endif
