/***************************************************************************

   Copyright (C) 2008 Christian Weilbach <christian_weilbach@web.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include <QtCore/QList>
#include <QtCore/QHash>
#include <QtCore/QVariant>

#include <KLocale>

#include "backend/bloglist.h"


QList<QHash<QString,QVariant> > BlogList()
{

QList<QHash<QString,QVariant> > blogList;
QHash<QString,QVariant> blogHash;

// specific matches -> to general matches

blogHash["api"] = "GData";
blogHash["sitename"] = "Blogspot.com";
blogHash["configInfo"] = i18n( "We have detected a Blogspot.com site. Blogspot uses GData API nowadays and you still cannot upload files to Blogspot.com itself. This means that you cannot use the media management to upload files." );
blogHash["hasUserProfiles"] = true;
blogHash["hasTitleSupport"] = true;
blogHash["hasCategorySupport"] = false;
blogHash["hasCommentSupport"] = true;
blogHash["hasDateTimeCreatedSupport"] = true;
blogHash["hasMediaSupport"] = false;
blogHash["hasMoodSupport"] = false;
blogHash["hasMusicSupport"] = false;
blogHash["hasPublishSupport"] = true;
blogHash["hasAllowCommentSupport"] = true;
blogHash["hasAllowTrackbackSupport"] = true;
blogHash["uploadMimetypes"] = QStringList();
blogHash["uploadMediaSize"]= 0; // set to 0 to disable
blogHash["blogIdRegexp"] = QRegExp( "BlogID=(\\d+)" );
blogHash["urlRegExp"] = QRegExp( "(blogger\\.com|Blogspot.com\\.com)" );
blogHash["urlTransformRegExp"] =  QRegExp( "(http://.+\\.(blogger|Blogspot.com)\\.com).+" ); // set a general gateway
blogHash["urlReplacementString"] = QString( "\\1" ); // no gateway here
blogHash["htmlRegExp"] = QRegExp( "content='blogger'\\s+name='generator'" );
blogHash["thumbnailRegExp"] = QRegExp( "(http://[\\d\\w]*\\.blogger\\.com/([\\d\\w]*/){1,4}s320/)?IMG_\\d*.[\\w]{3,3}" ); //TODO TEST IT!

blogList << blogHash;
blogHash.clear();

blogHash["api"] = "WordpressBuggy";
blogHash["sitename"] = "Wordpress.com";
blogHash["configInfo"] = i18n( "We have detected your Wordpress.com site." );
blogHash["hasUserProfiles"] = false;
blogHash["hasTitleSupport"] = true;
blogHash["hasCategorySupport"] = true;
blogHash["hasCommentSupport"] = false;
blogHash["hasDateTimeCreatedSupport"] = true;
blogHash["hasMediaSupport"] = true;
blogHash["hasMoodSupport"] = false;
blogHash["hasMusicSupport"] = false;
blogHash["hasPublishSupport"] = true;
blogHash["hasAllowCommentSupport"] = true;
blogHash["hasAllowTrackbackSupport"] = true;
blogHash["uploadMimetypes"] = QStringList() << "text/plain" << "image/png" << "image/jpg";
blogHash["uploadMediaSize"]= 1024; //in kb
blogHash["blogIdRegexp"] = QRegExp();
blogHash["urlRegExp"] = QRegExp( "Wordpress.com" );
blogHash["urlTransformRegExp"] =  QRegExp( "(http://.+\\.wordpress\\.com).+" ); // set a general gateway
blogHash["urlReplacementString"] = QString( "\\1/xmlrpc.php" );
blogHash["htmlRegExp"] = QRegExp( "name=\"generator\"\\s+content=\"WordPress.com\"" );
blogHash["thumbnailRegExp"] = QRegExp("(http://.*.files.wordpress.com/[\\d]{4,4}/[\\d]{2,2}/)?.*(.thumbnail|-[\\d]{,3}x[\\d]{,3}).[\\w]{3}"); // TODO TEST IT!

blogList << blogHash;
blogHash.clear();

blogHash["api"] = "Blogger1";
blogHash["sitename"] = "LiveJournal.com";
blogHash["configInfo"] = i18n( "We have detected your LiveJournal.com site." );
blogHash["hasUserProfiles"] = false;
blogHash["hasTitleSupport"] = true;
blogHash["hasCategorySupport"] = false;
blogHash["hasCommentSupport"] = false;
blogHash["hasDateTimeCreatedSupport"] = false; // not supported by Blogger1
blogHash["hasMediaSupport"] = false;
blogHash["hasMoodSupport"] = false;
blogHash["hasMusicSupport"] = false;
blogHash["hasPublishSupport"] = false;
blogHash["hasAllowCommentSupport"] = false;
blogHash["hasAllowTrackbackSupport"] = false;
blogHash["uploadMimetypes"] = QStringList();
blogHash["uploadMediaSize"]= 0; //in kb
blogHash["blogIdRegexp"] = QRegExp("\"currentJournal\":\\s+\"(.+)\"");
blogHash["urlRegExp"] = QRegExp( "LiveJournal.com" );
blogHash["urlTransformRegExp"] =  QRegExp( "(http://.+\\.livejournal\\.com).+" ); // set a general gateway
blogHash["urlReplacementString"] = QString( "http://www.liverjournal.com/interface/blogger/" );
blogHash["htmlRegExp"] = QRegExp( "rel=\"openid\\.server\"\\s+href=\"http://www\\.livejournal\\.com/openid/server\\.bml\"" );
blogHash["thumbnailRegExp"] = QRegExp(); // TODO

blogList << blogHash;
blogHash.clear();

blogHash["api"] = "WordpressBuggy";
blogHash["sitename"] = "Drupal";
blogHash["configInfo"] = i18n( "We have detected your personal Drupal installation." );
blogHash["hasUserProfiles"] = false;
blogHash["hasTitleSupport"] = true;
blogHash["hasCategorySupport"] = true;
blogHash["hasCommentSupport"] = false;
blogHash["hasDateTimeCreatedSupport"] = true;
blogHash["hasMediaSupport"] = true;
blogHash["hasMoodSupport"] = false;
blogHash["hasMusicSupport"] = false;
blogHash["hasPublishSupport"] = true;
blogHash["hasAllowCommentSupport"] = true;
blogHash["hasAllowTrackbackSupport"] = true;
blogHash["uploadMimetypes"] = QStringList();
blogHash["uploadMediaSize"]= 0; //in kb
blogHash["blogIdRegexp"] = QRegExp("blog"); // TODO this is not approved to be default for all drupal installations, yet
blogHash["urlRegExp"] = QRegExp( "/user/\\d" );
blogHash["urlTransformRegExp"] =  QRegExp( "(http://.+)" ); // set a general gateway //TODO
blogHash["urlReplacementString"] = QString( "\\1/xmlrpc.php" );
blogHash["htmlRegExp"] = QRegExp( "<style type=\"text/css\" media=\"all\">@import \".*/themes/.+\\.css\";</style>" );
blogHash["thumbnailRegExp"] = QRegExp(); // TODO

blogList << blogHash;
blogHash.clear();

blogHash["api"] = "WordpressBuggy";
blogHash["sitename"] = "Wordpress";
blogHash["configInfo"] = i18n( "We have detected your personal Wordpress installation." );
blogHash["hasUserProfiles"] = false;
blogHash["hasTitleSupport"] = true;
blogHash["hasCategorySupport"] = true;
blogHash["hasCommentSupport"] = false;
blogHash["hasDateTimeCreatedSupport"] = true;
blogHash["hasMediaSupport"] = true;
blogHash["hasMoodSupport"] = false;
blogHash["hasMusicSupport"] = false;
blogHash["hasPublishSupport"] = true;
blogHash["hasAllowCommentSupport"] = true;
blogHash["hasAllowTrackbackSupport"] = true;
blogHash["uploadMimetypes"] = QStringList() << "text/plain" << "image/png" << "image/jpg";
blogHash["uploadMediaSize"]= 1024; //in kb
blogHash["blogIdRegexp"] = QRegExp();
blogHash["urlRegExp"] = QRegExp(); // TODO maybe there is a typical url string to a wordpress user?
blogHash["urlTransformRegExp"] =  QRegExp( "(http://.+)" ); // set a general gateway // TODO
blogHash["urlReplacementString"] = QString( "\\1/xmlrpc.php" );
blogHash["htmlRegExp"] = QRegExp( "name=\"generator\"\\s+content=\"WordPress\\s+\\d\\.\\d\\.\\d\"" );
//"http://.*/wp-content/uploads/[\\d]{4,4}/[\\d]{2,2}/.*.thumbnail.[\\w]{3,3}" // TESTED with Wordpress < 2.5 
blogHash["thumbnailRegExp"] = QRegExp("(http://.*/wp-content/uploads/[\\d]{4,4}/[\\d]{2,2}/)?.*(.thumbnail|-[\\d]{,3}x[\\d]{,3}).[\\w]{3}"); //TESTED

blogList << blogHash;
blogHash.clear();

blogHash["api"] = "Blogger1";
blogHash["sitename"] = "General XML-RPC Gateway";
blogHash["configInfo"] = i18n( "For autoconfigure to work correctly you need to insert the URL to your blog's homepage and not the XML-RPC gateway.\n Otherwise this is your personal undetectable XML-RPC installation.\n We assume Blogger API 1.0 for now. If you are confident that your server supports more than that, chose Wordpress as type."  );
blogHash["hasUserProfiles"] = false;
blogHash["hasTitleSupport"] = true;
blogHash["hasCategorySupport"] = true;
blogHash["hasCommentSupport"] = false;
blogHash["hasDateTimeCreatedSupport"] = true;
blogHash["hasMediaSupport"] = true;
blogHash["hasMoodSupport"] = false;
blogHash["hasMusicSupport"] = false;
blogHash["hasPublishSupport"] = true;
blogHash["hasAllowCommentSupport"] = true;
blogHash["hasAllowTrackbackSupport"] = true;
blogHash["uploadMimetypes"] = QStringList() << "text/plain" << "image/png" << "image/jpg";
blogHash["uploadMediaSize"]= 1024; //in kb
blogHash["blogIdRegexp"] = QRegExp();
blogHash["urlRegExp"] = QRegExp();
blogHash["urlTransformRegExp"] =  QRegExp( "(http://.+)" ); // set a general gateway // TODO
blogHash["urlReplacementString"] = QString( "\\1" );
blogHash["htmlRegExp"] = QRegExp( "XML-RPC server accepts POST requests only." );
blogHash["thumbnailRegExp"] = QRegExp(); // TODO

blogList << blogHash;
blogHash.clear();

return blogList;
}