/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef IMAGE_MANAGER_H
#define IMAGE_MANAGER_H

#include <QDir>

#include "ui_imagemanagerbase.h"
namespace KBlogger
{

class KBloggerImageManager: public QWidget, public Ui::KBloggerImageManagerBase
{
    Q_OBJECT

    QImage *mImage;
    QDir *mTempDir;
    QString mFilename;
public:
    explicit KBloggerImageManager(QDir* tmpDir, QWidget *parent = 0);
    void setImage(const QString& filename);

protected Q_SLOTS:
    virtual void saveResize();
    virtual void comboSizeChanged(int);
    virtual void widthChanged();
    virtual void recalcSize(const QString& width);

Q_SIGNALS:
    void imageResized(const QString&);
};

} //namespace

#endif
