/***************************************************************************

   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>
   Copyright (C) 2008 Christian Weilbach <christian_weilbach@web.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "media/importmediadialog.h"

#include <KDialog>
#include <kdebug.h>

#include "media/importmediawidget.h"

namespace KBlogger
{

ImportMediaDialog *ImportMediaDialog::s_self = 0;

ImportMediaDialog *ImportMediaDialog::self(QWidget* parent)
{
    if ( !s_self ) {
        s_self = new ImportMediaDialog();
        s_self->initialize();
    }
    return s_self;
}

ImportMediaDialog::ImportMediaDialog(QWidget* parent) : KDialog( parent ),
        widget(0)
{
    kDebug();
    setCaption( i18n( "Import media files" ) );
    setButtons( KDialog::Ok | KDialog::Cancel );
    widget = new ImportMediaWidget( this );
    setMainWidget( widget );
}

ImportMediaDialog::~ImportMediaDialog()
{
    kDebug();
    s_self = 0;
    delete widget;
}

void ImportMediaDialog::initialize()
{
    kDebug();
    mUrlAdded = false;
    widget->clearList();
    enableButtonOk( true );
}

void ImportMediaDialog::addUrl(const QString& url, const QString& blogname, const QString& postId)
{
    kDebug();
    // widget->addUrl may reject adding blacklisted widgets
    if( widget->addUrl( url, blogname, postId ) )
        mUrlAdded = true;
}

void ImportMediaDialog::show()
{
    kDebug();
    if( mUrlAdded ) KDialog::show();
}

void ImportMediaDialog::accept()
{
    kDebug();
    enableButtonOk( false );
    Q_ASSERT(widget);
    widget->accept();
}

void ImportMediaDialog::reject()
{
    kDebug();
    close();
}

void ImportMediaDialog::close()
{
    kDebug();
    // we don't want to be closed, reuse and hide instead
    hide();
    initialize();
}

} //Namespace

#include "importmediadialog.moc"
