/***************************************************************************

   Copyright (C) 2005-2008 by Christian Weilbach <christian_weilbach@web.de>
   Copyright (C) 2007-2008 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef PROFILE_CONFIG_DIALOG_H
#define PROFILE_CONFIG_DIALOG_H

#include "ui_profileconfigdialogbase.h"

#include <kblog/blog.h>

#include "backend/backend.h"
#include "profileconfig.h"

class QTimer;
class QVariant;
class KConfigDialog;
class KProgressDialog;

namespace KIO
{
    class Job;
}
class KJob;


namespace KWallet
{
    class Wallet;
}

namespace KBlogger
{

/**
  @brief
  This class is handling the profile config dialog, which means it is doing the configuration
  of profiles actually. It has a neat autoconfiguration feature and uses the BlogList as 
  meta data for autoconfiguration..
*/

class ProfileConfigDialog : public QWidget, public Ui::ProfileConfigDialogBase
{
    Q_OBJECT

public:
    ProfileConfigDialog(KConfigDialog* parent);
    virtual ~ProfileConfigDialog();

    void readPasswordFromWallet();

private Q_SLOTS:
    void savePasswordToWallet();
    void enableFetchBlogId();
    void autoconfigure();
    void fetchBlogId();
    void fetchedBlogId( const QList<QMap<QString, QString> >& );
    void fetchedProfileId( const QString& );
    void handleFetchBlogIdError( KBlog::Blog::ErrorType, const QString& );
    void handleFetchIDTimeout();
    void handleFetchAPITimeout();

    void gotHtml(KJob *);

private:
    void showProgressDialog();
    void hideProgressDialog();
    void showMessageDialog(int api);
    
    KWallet::Wallet* mWallet;
    KConfigDialog* parent;
    KBlog::Blog* mBlog;
    QList<QHash<QString,QVariant> > mBlogList;
    QTimer* mFetchIdTimer;
    QTimer* mFetchAPITimer;
    KIO::Job *httpGetJob;
    bool mLastShot; // needed for a last attempt of autoconfiguration
    KProgressDialog  *mAutoConfProgressDialog;
};
}
#endif

