/***************************************************************************
 *   Copyright (C) 2004 by Roberto Virga                                   *
 *   rvirga@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlabel.h>
#include <qlayout.h>
#include <qscrollview.h>

#include <klocale.h>
#include <krun.h>
#include <kurllabel.h>

#include <kbssetiskymapwindow.h>

#include "kbssetiskymaplegend.h"

KBSSETISkyMapLegend::KBSSETISkyMapLegend(KBSSETISkyMapWindow *parent, const char *name)
                   : KBSStandardWindow(parent, name), m_view(new QVBox(this))
{
  setCaption(i18n("SETI@home Sky Map Legend"));
  
  setCentralWidget(m_view);
  setupView();
  
  setAutoSaveGeometry("SETI@home Sky Map Legend");
  
  setupActions();
}

const KBSSETISkyMapWindow *KBSSETISkyMapLegend::skyMap() const
{
  return static_cast<const KBSSETISkyMapWindow*>(parent());
}

QString KBSSETISkyMapLegend::text()
{
  const KBSSETISkyMapWindow *skyMap = this->skyMap();
  QString out;
  
  const unsigned constellations = skyMap->constellations();
  for(unsigned i = 0; i < constellations; ++i)
    out.append(i18n("%1\t%2\n").arg(skyMap->constellation(i)).arg(skyMap->constellationName(i)));
    
  return out;
}

void KBSSETISkyMapLegend::setupView()
{
  const KBSSETISkyMapWindow *skyMap = this->skyMap();
  
  QLabel *label;
  KURLLabel *urlLabel;

  label = new QLabel(i18n("Internet links courtesy of"), m_view);
  label->setAlignment(AlignCenter);

  urlLabel = new KURLLabel(skyMap->constellationURL().prettyURL(), skyMap->constellationName(), m_view);
  urlLabel->setAlignment(AlignCenter);
  urlLabel->setUseTips();
  urlLabel->setTipText(i18n("Click to visit web site"));

  connect(urlLabel, SIGNAL(leftClickedURL(const QString &)), this, SLOT(handleURL(const QString &)));

  QScrollView *scrollView = new QScrollView(m_view);
  scrollView->setResizePolicy(QScrollView::AutoOneFit);
  m_view->setStretchFactor(scrollView, 1);

  QWidget *grid = new QWidget(scrollView->viewport());
  scrollView->addChild(grid);

  const unsigned constellations = skyMap->constellations();
  QGridLayout *gridLayout = new QGridLayout(grid, constellations, 2, 2);
  gridLayout->setMargin(5);
  gridLayout->addColSpacing(0, 40);
  gridLayout->setColStretch(1, 1);

  for(unsigned i = 0; i < constellations; i++)
  {
    label = new QLabel(skyMap->constellation(i), grid);
    gridLayout->addWidget(label, i, 0);

    urlLabel = new KURLLabel(skyMap->constellationURL(i).prettyURL(), skyMap->constellationName(i), grid);
    urlLabel->setUseTips();
    urlLabel->setTipText(i18n("Click for more information"));
    gridLayout->addWidget(urlLabel, i, 1);

    connect(urlLabel, SIGNAL(leftClickedURL(const QString &)), this, SLOT(handleURL(const QString &)));
  }
}

void KBSSETISkyMapLegend::handleURL(const QString &url)
{
  KRun::runURL(url, "text/html", false, false);
}

#include "kbssetiskymaplegend.moc"
