/***************************************************************************
                          bodylayout.cpp  -  description
                             -------------------
    begin                : Sat May 20 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "bodylayout.h"

BodyLayout::BodyLayout(QWidget *parent, const char *name, int * st) : QDialog(parent,name,true)
{
	initDialog();
	Starting_Page = st;
	if (*Starting_Page)
		{
		Radio_frontpage->setChecked(true);
		SpinPage->setEnabled(true);
		SpinPage->setValue(*Starting_Page);
		}
	else
		{
		Radio_backpage->setChecked(true);
		SpinPage->setEnabled(false);
		}
	
	// connect some signals to some slots
	QObject::connect(OkButton, SIGNAL(clicked()), this, SLOT(CmOk()));
	QObject::connect(Radio_backpage, SIGNAL(clicked()), this, SLOT(slotBackpageSelected()));
	QObject::connect(Radio_frontpage, SIGNAL(clicked()), this, SLOT(slotFrontpageSelected()));
	setCaption(name);
}

BodyLayout::~BodyLayout()
{
}

/** user rpess ok button */
void BodyLayout::CmOk()
{
	if ( Radio_backpage->isChecked() )
		*Starting_Page = 0;
	else
		*Starting_Page = SpinPage->value();	
	accept();
}

/** user click radio backpage */
void BodyLayout::slotBackpageSelected()
{
	SpinPage->setEnabled(false);
}

/** user click front page radio */
void BodyLayout::slotFrontpageSelected()
{
	SpinPage->setEnabled(true);
}
