/***************************************************************************
                          kcoverback.cpp  -  description
                             -------------------
    begin                : Mon Apr 3 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcolor.h>

#include "kcoverback.h"

KCoverBack::KCoverBack()
{
	SideA = new KCoverString;
	SideB = new KCoverString;
	SideA->textcolor = new QColor(Qt::black);
	SideB->textcolor = new QColor(Qt::black);
	SideA->backcolor = new QColor(Qt::white);
	SideB->backcolor = new QColor(Qt::white);
	SlideTransparentBackground = true;
	SlideAlignement = Qt::AlignLeft;
	PageToPrint = false;
}

KCoverBack::~KCoverBack()
{
	delete SideB;
	delete SideA;
}

void KCoverBack::Clear()
{
	KCoverPage::Clear();
	delete SideA;
	delete SideB;
	SideA = new KCoverString;
	SideB = new KCoverString;
	SideA->textcolor = new QColor(Qt::black);
	SideB->textcolor = new QColor(Qt::black);
	SideA->backcolor = new QColor(Qt::white);
	SideB->backcolor = new QColor(Qt::white);
	SlideTransparentBackground = true;
	SlideAlignement = Qt::AlignLeft;
	PageToPrint = false;
}

void KCoverBack::Load( QFile &file, int version )
{
    char tmp;

	KCoverPage::Load( file, version );
	SideA->Load( file, version );
	SideB->Load( file, version );
	
	if ( version>3 )
		{
		file.readBlock( (char *)&tmp, sizeof( tmp ) );
	    if ( tmp=='T' )
	    	SlideTransparentBackground = true;
	    else
	    	SlideTransparentBackground = false;
	    }
	
	if ( version>4 )
		file.readBlock( (char *)&SlideAlignement, sizeof( SlideAlignement ) );
}

bool KCoverBack::Save( QFile &file, int page )
{
	char tmp;
	
	if ( SlideTransparentBackground )
		tmp='T';
	else
		tmp='O';
	if ( KCoverPage::Save( file, page ) )
		{
		SideA->Save( file );
		SideB->Save( file );
		file.writeBlock( (char *)&tmp, sizeof( tmp ) );
		file.writeBlock( (char *)&SlideAlignement, sizeof( SlideAlignement ) );
		return true;
		}
	else
		return false;
}

/** paint the page */
void KCoverBack::Paint(QPainter *paint, QPoint orig )
{
	// PeP 290601:
	Background.Paint( paint, orig+QPoint(BACK_HS+1,1), BACK_HI-1, BACK_V-1 );
	
	// draw the layout
	// PeP 290601:DrawLayout( paint, orig );

    // draw the images
    if ( Images.size() )
    	{
    	for (unsigned int i=0;i<Images.size();i++)
    		{
    		KCoverImage * img = GetImage(i);
			img->Paint( paint, orig, BACK_HI, BACK_V, BACK_HS );
    		}
    	}

    // draw the texts
    if ( Strings.size() )
    	{
    	for (unsigned int i=0;i<Strings.size();i++)
    		{
    		KCoverString * str = GetString(i);
    		str->Paint( paint, orig );
    		}
    	}

    // draw the curved texts
    if ( CurvedStrings.size() )
    	{
    	for (unsigned int i=0;i<CurvedStrings.size();i++)
    		{
    		KCoverCurvedString * str = GetCurvedString(i);
    		str->Paint( paint, orig );
    		}
    	}
    	
    // draw the multi line texts
    if ( MultiStrings.size() )
    	{
    	for (unsigned int i=0;i<MultiStrings.size();i++)
    		{
    		KCoverMultiString * str = GetMultiString(i);
    		str->Paint( paint, orig );
    		}
    	}

    // display the side texts
    if (!SlideTransparentBackground)
    	{
    	paint->fillRect( orig.x()+1, orig.y()+1, BACK_HS-1, BACK_V-1, QBrush(*( SideA->backcolor )));
    	paint->fillRect( orig.x()+BACK_HS+BACK_HI+1, orig.y()+1, BACK_HS-1, BACK_V-1, QBrush(*( SideB->backcolor )));
    	}

    // Side A
    paint->setFont(*(SideA->Font->Font));
    paint->translate( orig.x(), orig.y()+BACK_V );
    paint->rotate( -90 );
    paint->setPen(*(SideA->textcolor));
    paint->drawText( 10, 0, BACK_V-10, BACK_HS, SlideAlignement | Qt::AlignVCenter, SideA->text().latin1(), SideA->text().length() );
	paint->rotate( 90 );
	paint->translate( -orig.x(), -orig.y()-BACK_V );
	
    // Side B
    paint->setPen(*(SideB->textcolor));
    paint->setFont(*(SideB->Font->Font));
    //paint->translate( BACK_V, BACK_HS+BACK_HI );
    paint->translate( orig.x()+BACK_HI+2*BACK_HS, orig.y() );
    paint->rotate( 90 );
    paint->drawText( 10, BACK_HS-1, BACK_V-10, -BACK_HS, SlideAlignement | Qt::AlignVCenter, SideB->text().latin1(), SideB->text().length() );

    // transform again to set all the other things normally !
    paint->rotate( -90 );
    //paint->translate( 0, BACK_HI );
    paint->translate( -orig.x()-BACK_HI-2*BACK_HS, -orig.y() );

    // PeP 290601:
    DrawLayout( paint, orig );

}

/** draw the frame border (page bordrer) */
void KCoverBack::DrawLayout(QPainter *paint, QPoint orig)
{
	// draw the layout
	paint->setPen( Qt::black );

	paint->drawLine( orig.x(), orig.y(), orig.x()+BACK_HI+BACK_HS*2, orig.y() );
	paint->drawLine( orig.x(), orig.y()+BACK_V, orig.x()+BACK_HI+BACK_HS*2, orig.y()+BACK_V );
	paint->drawLine( orig.x(), orig.y(), orig.x(), orig.y()+BACK_V );
	paint->drawLine( orig.x()+BACK_HI+BACK_HS*2, orig.y(), orig.x()+BACK_HI+BACK_HS*2, orig.y()+BACK_V );
	paint->drawLine( orig.x()+BACK_HS, orig.y(), orig.x()+BACK_HS, orig.y()+BACK_V );
	paint->drawLine( orig.x()+BACK_HS+BACK_HI, orig.y(), orig.x()+BACK_HS+BACK_HI, orig.y()+BACK_V );
	
	// fill the inner rectangle with the page color
	//paint->fillRect( orig.x()+1, orig.y()+1, 2*BACK_HS+BACK_HI-1, BACK_V-1, PageColor );
	
	// paint the background
	// PeP 290601: Background.Paint( *paint, orig+QPoint(BACK_HS+1,1), BACK_HI-1, BACK_V-1 );
}

bool KCoverBack::IsPointInPage(QPoint ClickedPos)
{
	return ( ClickedPos.x()>=0 && ClickedPos.x()<=(BACK_HI+BACK_HS*2) && ClickedPos.y()>=0 && ClickedPos.y()<=BACK_V );
}

/** return  the page width in pixels */
const unsigned int KCoverBack::GetPageWidth() const
{
	return BACK_HI+2*BACK_HS;
}

/** return  the page height in pixels */
const unsigned int KCoverBack::GetPageHeight() const
{
	return BACK_V;
}

/** return the page left margin position */
const unsigned int KCoverBack::GetPageLeftMargin() const
{
	return BACK_HS;
}

/** return the page right margin position */
const unsigned int KCoverBack::GetPageRightMargin() const
{
	return BACK_HI+BACK_HS;
}

