/***************************************************************************
                          kcovercurvedstring.h  -  description
                             -------------------
    begin                : Sun Jun 18 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOVERCURVEDSTRING_H
#define KCOVERCURVEDSTRING_H

#include <kcoverstring.h>
#include <id.h>
#include <qstring.h>

class KCoverCurvedString : public KCoverString
{
public:
	KCoverCurvedString( QString text=QString(""), int x=0, int y=0, int order=0, unsigned char type=TYPE_CIRCLE, unsigned int r=50);
	//virtual ~KCoverCurvedString();
	KCoverCurvedString( const KCoverCurvedString &p );
	virtual int GetClassType() { return TYPE_CLASS_CURVED_STRING; }
	virtual void Paint(QPainter *, QPoint orig);
	/** set the type of the curved */
	void SetType(unsigned char);
	/* is a point in the rainbow/circle text ? */
	bool IsPointInObject(QPoint &pos);
	virtual int Width();
	virtual int Height();
	virtual int RealX();
	virtual int RealY();
	virtual void Load(QFile &file, int version);
	virtual void Save(QFile &file);

public:
	//QPoint Center;			// center of the circle
	unsigned int Radius;		// radius of the circle
	unsigned char Type;			// type of drawing
	float StartAngle;
	float StepAngle;
	float TotalAngle;
};

#endif
