/***************************************************************************
                          kcoverstring.h  -  description
                             -------------------
    begin                : Mon Apr 3 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOVERSTRING_H
#define KCOVERSTRING_H

#include <kcoverobject.h>
#include <kcoverfont.h>
#include <string>
#include <qcolor.h>
#include <qpainter.h>
#include <qfile.h>

/**this is a string objet for the cover
  *@author Pascal 'PeP' Panneels
  */

class KCoverString : public KCoverObject
{
public: 

  KCoverString(QString text="", int x=0, int y=0, int order=0);
  ~KCoverString();
  KCoverString( const KCoverString &p );

  virtual int GetClassType() {return TYPE_CLASS_STRING;} ;
  /** operator == for the comparison function */
  int operator == (const KCoverString &p) const;
  /** return true if clicked is on a text */
  virtual bool IsPointInObject(QPoint &pos);
  virtual int Width();
  virtual int Height();
  virtual void Paint( QPainter *, QPoint);
  virtual int RealX();
  virtual int RealY();
  virtual const int GetTopAlignDelta();
  virtual const int GetBottomAlignDelta();
  virtual const int GetMiddleAlignDelta();
  /** load an object */
  virtual void Load(QFile &file, int version);
  /** Save a string */
  virtual void Save(QFile &file);
  virtual void SetText(QString p);
  /** return the text buffer */
  virtual const QString text();
	
protected :
	QString Text;
	
public :
	KCoverFont * Font;
	QColor * backcolor;
	QColor * textcolor;
	bool transparentbackground;
	char alignoption;
};

#endif
