/***************************************************************************
                          stringeditdlg.cpp  -  description
                             -------------------
    begin                : Mon Apr 24 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "stringeditdlg.h"

StringEditDlg::StringEditDlg(QWidget *parent, const char *name, KCoverPage *page, KCoverString * str, QPoint pos)
 : QDialog(parent,name,true)
{
	initDialog();
	// init some components
	
	// initialize some variables
	TheString = str;
	ThePage = page;
	Pos = pos;
	if (str)
		{
		TextColor->setColor(*str->textcolor);
		BackColor->setColor(*str->backcolor);
		transparentbackground->setChecked(str->transparentbackground);
		BackColor->setEnabled(!str->transparentbackground);
		EditZone->setText(TheString->text().latin1());
		TheFont = *TheString->Font->Font;
		}
	else
		{
		TextColor->setColor(black);
		BackColor->setColor(white);
		transparentbackground->setChecked(true);
		BackColor->setEnabled(false);
		}
	// connect some signals to some slots
	QObject::connect(OkButton, SIGNAL(clicked()), this, SLOT(CmOk()));
	QObject::connect(CancelButton, SIGNAL(clicked()), this, SLOT(reject()));
	QObject::connect(transparentbackground, SIGNAL(clicked()), this, SLOT(CmTransparent()));
	QObject::connect(FontSelector, SIGNAL(clicked()), this, SLOT(slotFontSelect()));	
	setCaption(name);
}

/*StringEditDlg::~StringEditDlg()
{
}*/

/** manage the Ok press */
void StringEditDlg::CmOk()
{
	if (TheString)
		{
		TheString->SetText( QString( EditZone->text() ) );
		*TheString->backcolor = QColor( BackColor->color() );
		*TheString->textcolor = QColor( TextColor->color() );
		TheString->transparentbackground = transparentbackground->isChecked();
		if (TheString->Font->Font)
			delete TheString->Font->Font;
		TheString->Font->Font = new QFont(TheFont);
		
		}
	else
		{
		TheString = new KCoverString(QString(EditZone->text()), Pos.x(), Pos.y());
		TheString->backcolor = new QColor( BackColor->color() );
		TheString->textcolor = new QColor( TextColor->color() );
		TheString->transparentbackground = transparentbackground->isChecked();
		if (TheString->Font->Font)
			delete TheString->Font->Font;
		TheString->Font->Font = new QFont(TheFont);
		ThePage->AddString( TheString );
		}
		
	accept();
}

/** click on transparent checkbox */
void StringEditDlg::CmTransparent()
{
	BackColor->setEnabled(!transparentbackground->isChecked());
}

/** select the font */
void StringEditDlg::slotFontSelect()
{
     KFontDialog fontdlg(this, i18n("Select Font"), false, true);
     fontdlg.setFont(TheFont);
     int result = fontdlg.exec();
     if ( result == KFontDialog::Accepted )
		TheFont = fontdlg.font();
}

