/***************************************************************************
                          cddbaccessdialog.cpp  -  description
                             -------------------
    begin                : Sun May 20 2001
    copyright            : (C) 2001 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "cddbaccessdialog.h"
#include <qstring.h>
#include <string>
#include <qlistview.h>
#include <qheader.h>
#include <qmessagebox.h>
#include <cddbmatchcddlg.h>
#include <align.h>

CDDBAccessDialog::CDDBAccessDialog(KCoverBack *back, KCoverPage *front, QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	initDialog();

	setCaption(i18n("CDDB Native Protocol"));
	
	BackPage = back;
	FrontPage = front;
		
	// init some controls a little bit more
	Device_Edit->setText("/dev/cdrom");
	Server_Edit->setText("freedb.freedb.org");
	Port_Edit->setText("888");
	DiscID_Label->setText(i18n("no disc"));
	
	QObject::connect(OkButton, SIGNAL(clicked()), this, SLOT(CmOk()));
	QObject::connect(CancelButton, SIGNAL(clicked()), this, SLOT(reject()));
	QObject::connect(DiscIDButton, SIGNAL(clicked()), this, SLOT(CmDiscID()));
	QObject::connect(&cddb, SIGNAL(statusText(char * )), this, SLOT(slotStatusText(char * )));	
	QObject::connect(&audio_cd, SIGNAL(statusText(char * )), this, SLOT(slotStatusText(char * )));	
}

CDDBAccessDialog::~CDDBAccessDialog()
{
}

/** respond to ok clicked */
void CDDBAccessDialog::CmOk()
{
	DiscContent cdcontent;
	char buffer[256];
    unsigned long int discIDul = audio_cd.getDiscIDul();
	QString discIDstr = audio_cd.getDiscID();
    bool doQuery = true;
    CDDB_QueryReturnType rep = NO_MATCH;
	
	// just for debugging...
	//BackPage->SideA->SetText( QString("Side Test") );
	//KCoverString *objx = new KCoverString( string("Test String"), 30, 40 );
	//BackPage->AddString( objx );
	//objx = BackPage->GetLastString();	// get a pointer to the last inserted string in the page
	//objx->Align( *BackPage, Center, None );
	// end debug section
	while ( discIDul!=0 )
		{
		DiscID_Label->setText( discIDstr );
		if ( doQuery )
			{
			// process the cddb query
			cddb.setServerPort( QString(Server_Edit->text()), (unsigned short int)((Port_Edit->text()).toUShort()) );
			rep = cddb.query( discIDstr, audio_cd.getNumberTracks(), audio_cd.getTrackOffsets(), audio_cd.getTotalLength() );
			}
			
		switch ( rep )
			{
			case EXACT_MATCH :
				{
				cdcontent = cddb.getDiscContent();
				CDDBMatchCDDlg * dlg = new CDDBMatchCDDlg(cdcontent, this);
				if ( dlg->exec() )
					{
					// create objects on the different pages...
					// (1) Back Page
					BackPage->SideA->SetText( cdcontent.Artist+QString(" / ")+cdcontent.Head.DiscTitle );
					BackPage->SideB->SetText( cdcontent.Artist+QString(" / ")+cdcontent.Head.DiscTitle );
					KCoverString * obj = new KCoverString( cdcontent.Artist, 30, 20 );
					BackPage->AddString( obj );
					obj = BackPage->GetLastString();
					(obj)->Align( *BackPage, Center, None );
					obj = new KCoverString( cdcontent.Head.DiscTitle, 30, 40 ) ;
					BackPage->AddString( obj );
					(BackPage->GetLastString())->Align( *BackPage, Center, None );
					std::vector<QString> titles;
					for ( unsigned int i=0;i<cdcontent.Tracks.size();i++ )
						{
						sprintf(buffer,"%.02d. %s", i+1, (cdcontent.Tracks[i]).latin1() );
						titles.push_back( QString(buffer) );
						}
					BackPage->AddMultiString( new KCoverMultiString( titles, 30, 60, 0 ) );
					// (2) Front Page
					obj = new KCoverString( cdcontent.Artist, 40, 120 );
					FrontPage->AddString( obj );
					(FrontPage->GetLastString())->Align( *FrontPage, Center, None );
					obj = new KCoverString( cdcontent.Head.DiscTitle, 40, 170 );
					FrontPage->AddString( obj );
					(FrontPage->GetLastString())->Align( *FrontPage, Center, None );
					// quit the dialog box by OK
					accept();
					}
				else
					reject();
				discIDul = 0;
				}
                break;
			case INEXACT_MATCH :
				{
				unsigned int Selection;
				CDDBInexactMatchDlg * dlg = new CDDBInexactMatchDlg( cddb.getMatchedEntries(), &Selection, this );
				if ( dlg->exec() )
					{
					CDDB_Answer ans = cddb.read( (cddb.getMatchedEntries())[Selection].Category, (cddb.getMatchedEntries())[Selection].DiscID );
					if ( ans == C21x )
						{
						discIDul = 1;
						doQuery = false;
						rep = EXACT_MATCH;
						}
					else
						{
						reject();
						discIDul = 0;
						}
					}
				else
					{
					reject();
					discIDul = 0;
					}
				}
				break;			
			case NO_MATCH :
			case CONNECT_ERROR :
				{
				QMessageBox::warning( this, i18n("CDDB Results"), i18n("No matching or connexion error."), 1, Qt::NoButton);
				discIDul = 0;
				reject();
				}
				break;
			}
		}
}

/** compute the disc id after clicking */
void CDDBAccessDialog::CmDiscID()
{
	audio_cd.setDevice( (QString)(Device_Edit->text()) );
	QString discID =  audio_cd.getDiscID();
	if ( audio_cd.getDiscIDul()!=0 )
		DiscID_Label->setText( discID );
	else
		DiscID_Label->setText(i18n("no disc"));
}
/** respond to a signal for adding text to the status zone */
void CDDBAccessDialog::slotStatusText(char * txt)
{
	StatusZone->insertLine( txt );	
	repaint();	
}
