/***************************************************************************
                          kcoverback.h  -  description
                             -------------------
    begin                : Mon Apr 3 2000
    copyright            : (C) 2000 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOVERBACK_H
#define KCOVERBACK_H

#include <kcoverpage.h>
#include <kcoverstring.h>
#include <qfile.h>
#include <id.h>

/**Describes a CD cover for the back page (there is only one back page per CD)
  *@author Pascal 'PeP' Panneels
  */

class KCoverBack : public KCoverPage
{
public: 
	KCoverBack();
	~KCoverBack();
	void Clear();
	virtual void Load( QFile &, int version );
	virtual bool Save( QFile &, int );
    /** paint the page */
    void Paint(QPainter *paint, QPoint orig);
    /** draw the frame border (page bordrer) */
    virtual void DrawLayout(QPainter *paint, QPoint orig);
	virtual bool IsPointInPage(QPoint ClickedPos);
	/** return the page width in pixels */
  	virtual const unsigned int GetPageWidth() const;
  	/** return the page height in pixels */
  	virtual const unsigned int GetPageHeight() const;
	/** return the page left margin position */
  	virtual const unsigned int GetPageLeftMargin() const;
    /** return the page right margin position */
	virtual const unsigned int GetPageRightMargin() const;


public :
	KCoverString * SideA;
	KCoverString * SideB;
	bool SlideTransparentBackground;
	int SlideAlignement;
};

#endif
