/***************************************************************************
                          kcoverroundpage.cpp  -  description
                             -------------------
    begin                : Tue Mar 27 2001
    copyright            : (C) 2001 by Pascal 'PeP' Panneels
    email                : pepouille@skynet.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcoverroundpage.h>
#include <id.h>
#include <qcolor.h>

KCoverRoundPage::KCoverRoundPage()
 : KCoverPage()
{
	DrawBorder = true;
	DrawTiledBackgroundImage = false;
	rr = ROUND_SMALL/2;
	r=rr*rr;
	RR = ROUND_BIG/2;
	R=RR*RR;
	IsRoundPage = true;
}

/*KCoverRoundPage::~KCoverRoundPage()
{
}*/

void KCoverRoundPage::DrawLayout(QPainter *paint, QPoint orig)
{
	// save the brush and pen
	QBrush savedBrush = paint->brush();
	QPen savedPen = paint->pen();
	
	// draw the background
	RoundBackground.Paint( paint, orig, ROUND_BIG, ROUND_BIG );
		
	// draw the layout
  	if ( !DrawBorder )
		paint->setPen( Qt::NoPen );
  	else
  		paint->setPen( QColor(0,0,0) );
  	
	paint->setBrush( Qt::NoBrush );
	
	paint->drawEllipse( orig.x(), orig.y(), ROUND_BIG, ROUND_BIG );
	paint->drawEllipse( orig.x()+(ROUND_BIG/2)-(ROUND_SMALL/2), orig.y()+(ROUND_BIG/2)-(ROUND_SMALL/2), ROUND_SMALL, ROUND_SMALL );
	

	// draw the center point...	
	//paint->drawPoint( orig.x()+(ROUND_BIG/2), orig.y()+(ROUND_BIG/2) );
	
	// restore the saved brush and pen
	paint->setBrush( savedBrush );
	paint->setPen( savedPen );
}

/** draw the images */
void KCoverRoundPage::DrawImages(QPainter *paint, QPoint orig)
{
    if ( Images.size() )
    	{
    	for (unsigned int i=0;i<Images.size();i++)
    		{
    		KCoverImage * img = GetImage(i);
			img->Paint( paint, orig, ROUND_BIG, ROUND_BIG, 0, true, DrawBorder );
    		}
    	}
}

bool KCoverRoundPage::IsPointInPage(QPoint ClickedPos)
{
	int x = ClickedPos.x()-RR;
	int y = ClickedPos.y()-RR;	
	int A = x*x+y*y;
	
	return ( A<R && A>r  );
}

bool KCoverRoundPage::Save(QFile &file, int page)
{
	if ( KCoverPage::Save( file, page ) )
		{
		RoundBackground.Save(file);
		return true;
		}
	else
		return false;
}

void KCoverRoundPage::Load(QFile &file, int version)
{
	KCoverPage::Load(file,version);
	if (version>2)
		RoundBackground.Load( file,version );
}

void KCoverRoundPage::Clear()
{
	KCoverPage::Clear();
	RoundBackground.Clear();
}

/** return  the page width in pixels */
const unsigned int KCoverRoundPage::GetPageWidth() const
{
	return ROUND_BIG;
}

/** return  the page height in pixels */
const unsigned int KCoverRoundPage::GetPageHeight() const
{
	return ROUND_BIG;
}

/** return the page left margin position */
const unsigned int KCoverRoundPage::GetPageLeftMargin() const
{
	return 0;
}

/** return the page right margin position */
const unsigned int KCoverRoundPage::GetPageRightMargin() const
{
	return ROUND_BIG;
}
