/***************************************************************************
                          kconfigure.cpp  -  description
                             -------------------
    begin                : s� ene  6 16:35:16 CET 2001
    copyright            : (C) 2001-2005 by Javier Campos Morales & the Kconfigure Team
    email                : kconfigure@rockerssoft.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kconfigure.h"
#include "kconfigure.moc"

#include "kcpreferences.h"
#include "configurewizard.h"
#include "logwindow.h"
#include "extractdlg.h"

#include <klineeditdlg.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qfile.h>
#include <qtextstream.h>

#include <kfiledialog.h>
#include <kedittoolbar.h>
#include <kkeydialog.h>
#include <kglobalsettings.h>
#include <kmessagebox.h>


Kconfigure::Kconfigure(QWidget *parent, const char *name, WFlags f) : KMainWindow(parent, name, f)
{
	setMinimumSize(100, 100);
	setMaximumSize(32767, 32767);

	setupMenuBar();
	init();
	configRead();
}

Kconfigure::~Kconfigure()
{
}

/** Init main window */
void Kconfigure::init()
{
	QWidget *mainView = new QWidget(this);

	QVBoxLayout *mainLayout = new QVBoxLayout( mainView );
	mainLayout->setSpacing( 6 );
	mainLayout->setMargin( 6 );

	s1 = new QSplitter( QSplitter::Vertical, mainView, "top" );
	mainLayout->addWidget( s1 );
	
	view_main = new QMultiLineEdit( s1, "TextView2" );
			view_main->setText("");
	
	QGroupBox *GroupBox1 = new QGroupBox( s1, "GroupBox1" );
	GroupBox1->setTitle( i18n( "Warnings &  Errors"  ) );
	GroupBox1->setColumnLayout(0, Qt::Vertical );
	GroupBox1->layout()->setSpacing( 0 );
	GroupBox1->layout()->setMargin( 0 );
	QVBoxLayout *GroupBox1Layout = new QVBoxLayout( GroupBox1->layout() );
	GroupBox1Layout->setAlignment( Qt::AlignTop );
	GroupBox1Layout->setSpacing( 6 );
	GroupBox1Layout->setMargin( 6 );
	
	view_errors = new QMultiLineEdit(GroupBox1, "view_errors" );
	GroupBox1Layout->addWidget( view_errors );

	QApplication::connect( &q, SIGNAL(receivedStdout(KProcess *, char *, int)),this,SLOT(slotOutputMessages(KProcess *, char *, int)));
	QApplication::connect( &q, SIGNAL(receivedStderr(KProcess *, char *, int)),this,SLOT(slotOutputMessagesError(KProcess *, char *, int)));
	QApplication::connect( &q, SIGNAL(processExited(KProcess *)),this, SLOT(slotFinishAction()) );

	mainView->show();
	this->setCentralWidget( mainView );
}

/** Init the menu bar */
void Kconfigure::setupMenuBar()
{

	KStdAction::open(this, SLOT( openURLnew() ), actionCollection());
	recentFiles = KStdAction::openRecent(this, SLOT ( openURL(const KURL &)), actionCollection());
	KStdAction::quit(this, SLOT( slotMenuQuit() ), actionCollection());

	actionStop = 		new KAction(i18n("&Kill Process"), "stop", Key_Escape, this, SLOT( slotKillProcess() ), actionCollection(), "stop");
	actionStop -> setWhatsThis (i18n("This will stop the current action."));
	
	actionConfigure = 	new KAction(i18n("&Configure"), "configureproject", 0, this, SLOT( slotExecuteConfigure() ), actionCollection(), "configure");
	actionConfigure -> setWhatsThis (i18n("This runs Configure on the project."));	
	
	actionConfigureHelp = new KAction(i18n("C&onfigure help"), 0, this, SLOT( slotExecuteConfigure_Help() ), actionCollection(), "configure_help");
	actionConfigureHelp -> setWhatsThis (i18n("This allows you to pick arguments from a list to pass to Configure."));	
	
	actionConfigureArg = new KAction(i18n("Configure with &arguments..."), 0, this, SLOT( slotExecuteConfigure_Args() ), actionCollection(), "configure_arg");
	actionConfigureArg -> setWhatsThis (i18n("This allows you to manually pass arguments to Configure."));	
	
	actionQmake = 		new KAction(i18n("&Qmake"), "designer", 0, this, SLOT( slotExecuteQmake() ), actionCollection(), "qmake");
	actionQmake -> setWhatsThis (i18n("The runs Qmake."));
	
	actionQmakeArg = 	new KAction(i18n("Qmake with ar&guments..."), 0, this, SLOT( slotExecuteQmake_Args() ), actionCollection(), "qmake_arg");
	actionQmakeArg -> setWhatsThis (i18n("This allows you to pass arguments to Qmake."));	
	
	actionMake = 		new KAction(i18n("&Make"), "compile", Key_F8, this, SLOT( slotExecuteMake() ), actionCollection(), "make");
	actionMake -> setWhatsThis (i18n("This runs Make on the project."));	
	
	actionMakeClean = 	new KAction(i18n("Make C&lean"), 0, this, SLOT( slotExecuteMake_Clean() ), actionCollection(), "make_clean");
	actionMakeClean -> setWhatsThis (i18n("The runs Make Clean on the project."));	
	
	actionMakeArg = 	new KAction(i18n("Make with a&rguments"), 0, this, SLOT( slotExecuteMake_Args() ), actionCollection(), "make_arg");
	actionMakeArg -> setWhatsThis (i18n("This allows you to manually pass arguments to Make."));
		
	actionInstall = 		new KAction(i18n("In&stall"), "install", Key_F9, this, SLOT( slotSelectExecuteInstall() ), actionCollection(), "install");
	actionInstall -> setWhatsThis (i18n("This runs the currently selected Install option."));	
	
	actionInstallWhich = 	new KSelectAction(i18n("Install &With"), 0, 0, this,  SLOT( slotSelectInstall() ), actionCollection(), "which_install");
	slotSetInstallOption();	
	
	setActionMode( false, false );

	toolbarAction = KStdAction::showToolbar(this, SLOT( slotMenuToggleToolBar()), actionCollection());
	KStdAction::keyBindings		(this, SLOT( slotMenuConfigureKeys() ), actionCollection());
	KStdAction::configureToolbars	(this, SLOT( slotMenuConfigureToolbar() ), actionCollection());
	KStdAction::preferences		(this, SLOT( slotMenuConfigure()), actionCollection());

	KAction *openTerm = new KAction(i18n("Open Terminal"), "openterm", Key_F4, this, SLOT( slotOpenTerminal() ),  actionCollection(), "open_terminal");
	openTerm -> setWhatsThis (i18n("Opens a Konsole session in the current build directory."));
	
	KAction *editClear = new KAction(i18n("&Clear main text"), "editclear", 0, this, SLOT( slotClearMain() ), actionCollection(), "cl_mai");
	editClear -> setWhatsThis (i18n("Clears the main text."));
	
	KAction *errorClear = new KAction(i18n("C&lear error text"), "errorclear", 0, this, SLOT( slotClearError() ), actionCollection(), "cl_err");
	errorClear -> setWhatsThis (i18n("Clears the error text."));
	
	KAction *eraser = new KAction(i18n("C&lear all text"), "eraser", 0, this, SLOT( slotClearAll() ), actionCollection(), "cl_all");
	eraser -> setWhatsThis (i18n("Clears all the text."));
	

	actionfilemenu_README = new KAction(i18n("view README"), "contents", 0, this, SLOT( slotReadREADME() ), actionCollection(), "README");
	actionfilemenu_README ->setEnabled( false );
	actionfilemenu_README -> setWhatsThis (i18n("View the README file."));
	
	actionfilemenu_INSTALL = new KAction(i18n("view INSTALL"), "contents", 0, this, SLOT( slotReadINSTALL() ), actionCollection(), "INSTALL");
	actionfilemenu_INSTALL ->setEnabled( false );
	actionfilemenu_INSTALL -> setWhatsThis (i18n("View the INSTALL file."));
	
	actionfilemenu_CHANGELOG = new KAction(i18n("view ChangeLog"), "contents", 0, this, SLOT( slotReadCHANGELOG() ), actionCollection(), "CHANGELOG");
	actionfilemenu_CHANGELOG ->setEnabled( false );
	actionfilemenu_CHANGELOG -> setWhatsThis (i18n("View the ChangeLog file."));

	filemenu_start_log = new KToggleAction( i18n("&Start log"), 0, this, SLOT( slotLogStart() ), actionCollection(), "start_log");
	filemenu_start_log -> setWhatsThis (i18n("Start the log."));
	
	KAction *viewLog = new KAction( i18n("&View current log"), 0, this, SLOT( slotLogView() ), actionCollection(), "view_log");
	viewLog -> setWhatsThis (i18n("View the current log."));
	
	KAction *logEraser = new KAction( i18n("&Clear current log"), "logeraser", 0, this, SLOT( slotLogClear() ), actionCollection(), "clear_log");
	logEraser -> setWhatsThis (i18n("Clear the current log."));
	
	KAction *logSave = new KAction( i18n("S&ave current log"), "filesave", 0, this, SLOT( slotLogSave() ), actionCollection(), "save_log");
	logSave -> setWhatsThis (i18n("Save the current log."));

	AnimatedLogo = new KonqLogoAction( i18n("Animated Logo"), 0, this, SLOT( slotKillProcess() ), actionCollection(), "animated_logo" );

	createGUI("kconfigureui.rc");
	
}

/** Quit the kconfigure program */
void Kconfigure::slotMenuQuit()
{
	qApp->quit();
}

/** Toggle Toolbar */
void Kconfigure::slotMenuToggleToolBar()
{
  bool show_toolbar = toolbarAction->isChecked();
  if (show_toolbar)
     toolBar("mainToolBar")->show();
  else
     toolBar("mainToolBar")->hide();
}

/** Configure Toolbar */
void Kconfigure::slotMenuConfigureToolbar()
{
	KEditToolbar edit( guiFactory(), this );
	edit.exec();
}

/** Configure keys */
void Kconfigure::slotMenuConfigureKeys()
{
	KKeyDialog::configure( actionCollection(), xmlFile() );
}

/** Log options */
void Kconfigure::slotLogStart()
{
	if( logOn == true )
	{
		logOn = false;
	}
	else
	{
		logOn = true;
		logString = "";
	}
}

/** Log options */
void Kconfigure::slotLogView()
{
	if( logString.isEmpty() || logString == QString::null )
	{
		KMessageBox::sorry(this, i18n("The log is empty.\n\nYou must start the log"), i18n("Sorry"), false);
		return;
	}

	LogWindow *showLog = new LogWindow(this, "log");
	showLog->setText( logString );
	showLog->show();
}

/** Log options */
void Kconfigure::slotLogClear()
{
	logString = "";
}

/** Log options */
void Kconfigure::slotLogSave()
{
	KConfig *config = KGlobal::config();
	QString filter;
	QString initDir = filePath;

	if( logString.isEmpty() || logString == QString::null )
		{
		KMessageBox::sorry(this, i18n("The log is empty.\n\nYou must start the log"), i18n("Sorry"), false);
		return;
		}

	if( config->readBoolEntry( "Log in dir", false ) )
		{
		initDir = config->readEntry( "Directory", "" );
		}

	if( logHtml )
		filter = "*.html,*.HTML|"+i18n("HTML Source");
	else
		filter = "*";

	QString fileSave =  KFileDialog::getSaveFileName( initDir, filter, 0,  i18n("Save log file") );

	if( !fileSave.isEmpty() )
	{
		QFile file( fileSave );
		if ( file.open( IO_WriteOnly ) )
		{
			QTextStream stream(&file);
			stream << logString;
			file.close();
		}
	}
}

/** Read the config */
void Kconfigure::configRead()
{
	KConfig *config = KGlobal::config();

	config->setGroup("General");
	QSize *defaultSize = new QSize(350,400);
	this->resize( config->readSizeEntry("Geometry", defaultSize ) );
	s1->setSizes( config->readIntListEntry("Splitter_size") );
	recentFiles->loadEntries(config);

	QFont defaultFont(KGlobalSettings::generalFont());
	view_main->setFont( config->readFontEntry( "Font log", &defaultFont ) );
	view_errors->setFont( config->readFontEntry( "Font error", &defaultFont ) );

	config->setGroup("Log");	
	logOn = config->readBoolEntry( "Log start", true );
	filemenu_start_log->setChecked( logOn );
	logHtml =	config->readBoolEntry( "Log in html", true );
}

/** Write the settings */
void Kconfigure::configWrite()
{
  KConfig *config = KGlobal::config();

	config->setGroup("General");
	config->writeEntry("Geometry", this->size() );
	config->writeEntry("Splitter_size", s1->sizes() );
	recentFiles->saveEntries(config);

	config->sync();
}

/** Exit the program */
bool Kconfigure::queryExit()
{
	configWrite();
	return true;
}

/** Execute a command file */
void Kconfigure::execute(const char *file)
{
	QString Comm_Args;
	QString SFile = file;
	int buflen = SFile.length();
	if(q.isRunning()==true){
		KMessageBox::error(0, i18n("SORRY !\n\nWait until the process finish.\n"), i18n("I cannot do this !"), false);
		return;
	}
	if( filePath == QString::null || filePath == "" )
	{
		KMessageBox::sorry(0, i18n("You must to select a project with configure file."), i18n("Execute command error"), false);
		return;
	}

	qDir.setCurrent( filePath );

	view_main->clear();
	view_main->setWordWrap( QMultiLineEdit::NoWrap );
	view_errors->clear();
	streamLine = "";
	FatalError=false;

	// and identify after space like arguments
	for( int i = 0; i < buflen; i++ )
	{
	if( *file == ' ' )
		{
		q << Comm_Args;
		Comm_Args = "";
		} else {
		Comm_Args += *file;
		}
	++file;
	}
	q << Comm_Args;

	setActionMode( false, true );
	AnimatedLogo->start();
  q.start( KProcess::NotifyOnExit, KProcess::AllOutput );
}

/** Output the messages error */
void Kconfigure::slotOutputMessagesError(KProcess*,char* buffer,int buflen)
{
	for( int i = 0; i < buflen; i++ )
	{
		if( *buffer == '\n' )
		{
			view_errors->insertLine( streamLine );
			view_errors->setCursorPosition(view_errors->numLines(),0);
			if( logOn )
			{
				if( logHtml )
					logString += "<font color=#b84747>" + streamLine + "</font><br>";
				else
					logString += "|WW| " + streamLine + "\n";
			}
			streamLine = "";
		} else {
			streamLine += *buffer;
		}
		++buffer;
	}

}

/** Output the exec output */
void Kconfigure::slotOutputMessages(KProcess*,char *buffer,int buflen)
{

	for( int i = 0; i < buflen; i++ )
	{
		if( *buffer == '\n' )
		{
			view_main->insertLine( streamLine );
			if( logOn )
			{
				if( logHtml )
					logString += streamLine + "<br>";
				else
					logString += streamLine + "\n";
			}
			view_main->setCursorPosition(view_main->numLines(),0);
			streamLine = "";
		} else {
		streamLine += *buffer;
		}
		++buffer;
	}

}

/** Finish the process */
void Kconfigure::slotFinishAction()
{
	stop_time();
	q.clearArguments();
	AnimatedLogo->stop();
	setActionMode( true, false);

	if( q.normalExit() && q.exitStatus()==0 )
	{
		KNotifyClient::event("finish", i18n("The process has finished") );
	}

	if( logOn )
	{
		if( logHtml )
			logString += "</TD></TR></TABLE><P></P>";
		else
			logString += ">> " + i18n("Process finish.") + "\n\n";
	}
}

/** Execute configure */
void Kconfigure::slotExecuteConfigure()
{
	if( logOn )
	{
		time.start();
		if( logHtml )
			headerHTML( i18n("Configure") );
		else
			logString += ">> " + i18n("Configure") + "\n\n";
	}
	execute("./configure");
}

/** Execute configure */
void Kconfigure::slotExecuteConfigure_Args()
{
	KLineEditDlg argdlg( i18n("Configure with Arguments"), "", this);
	if(argdlg.exec())
	{
		execute( "./configure "+(argdlg.text()));
		if( logOn )
		{
			time.start();
			if( logHtml )
				headerHTML( i18n("Configure %1").arg(argdlg.text()) );
			else
				logString += ">> " + i18n("Configure %1").arg(argdlg.text()) + "\n\n";
		}
	}
}

/** Configure --help */
void Kconfigure::slotExecuteConfigure_Help()
{
	ConfigureWizard cnfdlg(this,"ConfWiz",filePath);

	if(cnfdlg.exec())
	{
		if( cnfdlg.getArguments()!= "" )
		{
			if( KMessageBox::warningYesNo(this, i18n(" This is an experimental feature.!!\n\nThe arguments are:\n")+cnfdlg.getArguments()+i18n("\n\nAre the arguments correct?"), i18n("Warning"), i18n("&Yes"), i18n("&No"), false) == 4 ) return;
			execute( "./configure " + cnfdlg.getArguments() );
			if( logOn )
			{
				time.start();
				if( logHtml )
					headerHTML( i18n("Configure %1").arg(cnfdlg.getArguments()) );
				else
					logString += ">> " + i18n("Configure %1").arg(cnfdlg.getArguments()) + "\n\n";
			}
		}
	}
}

/** Execute make */
void Kconfigure::slotExecuteMake()
{
	execute("make");
	if( logOn )
	{
		time.start();
		if( logHtml )
			headerHTML( i18n("Compile sources") );
		else
			logString += ">> " + i18n("Compile sources") + "\n\n";
	}
}

/** Execute make with arguments */
void Kconfigure::slotExecuteMake_Args()
{
	KLineEditDlg argdlg( i18n("Make with Arguments"), "", this);
	if(argdlg.exec())
	{
		execute( "make "+(argdlg.text()));
		if( logOn )
		{
			time.start();
			if( logHtml )
				headerHTML( i18n("make %1").arg(argdlg.text()) );
			else
				logString += ">> " + i18n("make %1").arg(argdlg.text()) + "\n\n";
		}
	}
}

/** Make clean */
void Kconfigure::slotExecuteMake_Clean()
{
	execute("make clean");
	if( logOn )
		{
		time.start();
		if( logHtml )
			headerHTML( i18n("make clean") );
			else
			logString += ">> " + i18n("make clean") + "\n\n";
		}
}

/** Install Options menu, hopefully this will let us select our install method on-the-fly */
void Kconfigure::slotSetInstallOption()  {

	KConfig *config = KGlobal::config();
	//get out list and make sure its ok/update
	QStringList list;

	list.append(i18n("Make Install"));
	list.append(i18n("User Install"));
	
	config->setGroup("Checkinstall");
	bool checkinstall = config->readBoolEntry( "Enable Checkinstall", false );
	
	config->setGroup("InstallOptions");
	int wInstall = config->readNumEntry( "Use Install", 1 );
	
	if( checkinstall ) { 
		list.append(i18n("Check Install")); 
		
	} else if( wInstall == 2 ) { wInstall = 0; } 
	
	//Set and use our configuration.
	actionInstallWhich->setItems(list);
	actionInstallWhich->setCurrentItem( wInstall );

	config->sync();

}

/** Install option list slot.  Sets the config setting to the current menu selection */
void Kconfigure::slotSelectInstall( )
{

	KConfig *config = KGlobal::config();
	config->setGroup("InstallOptions");
	int currentOption = actionInstallWhich->currentItem();
	config->writeEntry( "Use Install", currentOption );
	
	config->sync();
	
}

/** Do a Standard make install */
void Kconfigure::slotExecuteInstall()
{
	execute("cd \"" + filePath + "\" && make install");
	if( logOn )
	{
		time.start();
		if( logHtml )
			headerHTML( i18n("make install (single user)") );
		else
			logString += ">> " + i18n("make install (single user)") + "\n\n";
	}
}

/** Do a Systemwide Root make install */
void Kconfigure::slotExecuteInstallRoot()
{
	// execute("kdesu -t make install");
	// Fix by Alvin Beach for kdesu that passes login shells
	execute("kdesu -t \"cd " + filePath + " && make install\"");
	
	if( logOn )
	{
		time.start();
		if( logHtml )
			headerHTML( i18n("make install (root user)") );
		else
			logString += ">> " + i18n("make install (root user)") + "\n\n";
	}
}

/** Do a Systemwide Root Checkinstall */
void Kconfigure::slotExecuteCheckInstallRoot()
{

	KConfig *config = KGlobal::config();
	config->setGroup("Checkinstall");
	QString ExeChechInstall = config->readEntry( "Checkinstall Command", "/usr/sbin/checkinstall" );
	
	QString pakForm = "R";
	bool isRPM = config->readBoolEntry( "RPM Package", true );
	bool isDEB = config->readBoolEntry( "Debian Package", false );
	bool isSLK = config->readBoolEntry( "Slackware Package", false );
	
	if(isDEB) { pakForm = "D"; }
	else if (isSLK) { pakForm = "S"; }
	else if (isRPM) { pakForm = "R"; }
	else { pakForm = "R"; }
	
	QString elfBin = config->readBoolEntry( "Strip Elf Binaries", true ) ? "yes" : "no";
	QString backUp = config->readBoolEntry( "Backup Overwrite Files", true ) ? "yes" : "no";
	QString customOptions = config->readEntry( "Custom Options", "--pkgrelease=1.kcfg" );

	/** Assemble our checkinstall script */
	execute( "kdesu -t ' cd " + filePath + " && " + ExeChechInstall + " -y" + pakForm + " --strip=" + elfBin + " --backup=" + backUp + " " + customOptions + "'" );

	if( logOn )
	{
		time.start();
		if( logHtml )
			headerHTML( i18n("checkinstall (root user)") );
		else
			logString += ">> " + i18n("checkinstall (root user)") + "\n\n";
			logString += ">> " + i18n("kdesu -t ' cd " + filePath + " && " + ExeChechInstall + " -y" + pakForm + " --strip=" + elfBin + " --backup=" + backUp + " " + customOptions + "'") + "\n\n";
	}
}

/** Open a Terminal Window in application directory */
void Kconfigure::slotOpenTerminal()
{
	KConfig *config = KGlobal::config();
	config->setGroup( "General" );
	QString term = config->readPathEntry( "TerminalApplication", "konsole" );
	
	QString dir = "/";
	
	if ( !filePath )
	{
		dir = QDir::homeDirPath();
	} else {
		dir = filePath;
	}
	
	KProcess cmd;
	cmd.setWorkingDirectory(dir);
	cmd << term;
	cmd.start(KProcess::DontCare);
}

/** Kill the process */
void Kconfigure::slotKillProcess()
{
//	if( !q.isRunning() ) return;
	q.kill();
	if( logOn )
	{
		stop_time();
		if( logHtml )
			logString += "<P><B>" + i18n("Process killed") + "</B></P>";
		else
			logString += ">> " + i18n("Process killed") + "\n\n";
	}
}

/** Open file  */
void Kconfigure::openURL( const KURL &url )
{

	if( url.fileName().right(6) == "tar.gz" || url.fileName().right(4) == ".tgz" )
	{
		if( !openExtractURL( url, "z" ) ) return;
	}
	else if ( url.fileName().right(7) == "tar.bz2" ) 
	{
		if( !openExtractURL( url, "j" ) ) return;
	}
	else
	{
		filePath = url.directory(false,true);
		fileName = url.fileName();
		recentFiles->addURL( url );
	}

	if( logOn )
	{
		if( logHtml )
			logString += "<p><b>" + i18n("Open project : %1").arg(filePath) + "</b></p>";
		else
			logString += ">> " + i18n("Open project : %1").arg(filePath) + "\n\n";
	}

	this->setCaption("[" + filePath + "]" );
	if( QFile::QFile(filePath+"README").exists() ) 	
	{
		actionfilemenu_README->setEnabled(true);
		file_README = "README";
	} else if( QFile::QFile(filePath+"readme").exists() )
	{
		actionfilemenu_README->setEnabled(true);
		file_README = "readme";
	} else if( QFile::QFile(filePath+"Readme").exists() )
	{
		actionfilemenu_README->setEnabled(true);
		file_README = "Readme";
	}

	if( QFile::QFile(filePath+"INSTALL").exists() ) 	
	{
		actionfilemenu_INSTALL->setEnabled(true);
		file_INSTALL = "INSTALL";
	} else if( QFile::QFile(filePath+"install").exists() )
	{
		actionfilemenu_INSTALL->setEnabled(true);
		file_INSTALL = "install";
	} else if( QFile::QFile(filePath+"Install").exists() )
	{
		actionfilemenu_INSTALL->setEnabled(true);
		file_INSTALL = "Install";
	}

	if( QFile::QFile(filePath+"CHANGELOG").exists() ) 	
	{
		actionfilemenu_CHANGELOG->setEnabled(true);
		file_CHANGELOG = "CHANGELOG";
	} else if( QFile::QFile(filePath+"changelog").exists() )
	{
		actionfilemenu_CHANGELOG->setEnabled(true);
		file_CHANGELOG = "changelog";
	} else if( QFile::QFile(filePath+"ChangeLog").exists() )
	{
		actionfilemenu_CHANGELOG->setEnabled(true);
		file_CHANGELOG = "ChangeLog";
	} else if( QFile::QFile(filePath+"Changelog").exists() )
	{
		actionfilemenu_CHANGELOG->setEnabled(true);
		file_CHANGELOG = "Changelog";
	}
	setActionMode( true, false );
}

/** Configure dialog */
void Kconfigure::slotMenuConfigure()
{
	Kcpreferences *pref = new Kcpreferences();
	pref->show();
	
	slotSetInstallOption();
}

/** Clear output text */
void Kconfigure::slotReadREADME()
{
	openViewFile( file_README );
}

/** Clear output text */
void Kconfigure::slotReadINSTALL()
{
	openViewFile( file_INSTALL );
}

/** Clear output text */
void Kconfigure::slotReadCHANGELOG()
{
	openViewFile( file_CHANGELOG );
}

/** Open file in main window */
void Kconfigure::openViewFile( const QString &filename )
{
	QString fname( filePath + filename );
	QFile file( filePath + filename );
	if ( file.open(IO_ReadOnly) )
	{
		QTextStream stream(&file);
		view_main->clear();
		view_main->setWordWrap( QMultiLineEdit::WidgetWidth );
		view_main->setText( stream.read() );
		file.close();
	}
}

/** Clear output text */
void Kconfigure::slotClearMain()
{
	view_main->clear();
}

/** Clear output text */
void Kconfigure::slotClearError()
{
	view_errors->clear();
}

/** Clear output text */
void Kconfigure::slotClearAll()
{
	view_main->clear();
	view_errors->clear();
}

/** Open new URL */
void Kconfigure::openURLnew()
{
	KURL url = KFileDialog::getOpenURL( QString::null, "*.tar.gz *.tgz *.tar.bz2|All source packages\nconfigure|configure files\n*.tar.gz *.tgz|Source gzip compress (tar.gz)\n*.tar.bz2|Source bzip2 compress (tar.bz2)", 0,  i18n("Open configure file or source package") );
	if( !url.isEmpty() && url.isLocalFile() )
		openURL( url );
}

/** No descriptions */
void Kconfigure::headerHTML( const QString &command )
{
	logString += "<TABLE WIDTH=100% BORDER=0 CELLPADDING=0 CELLSPACING=0><THEAD><TR>";
	logString += "<TH BGCOLOR=#006b6b><P ALIGN=LEFT><FONT COLOR=#ffffff SIZE=4>";
	logString += command;
	logString += "</FONT></TH></TR></THEAD><TR><TD BGCOLOR=#eeeeee >";
}

/** Stop time and print into log */
void Kconfigure::stop_time()
{
	int msec = time.elapsed();	
	int hour = msec/3600000;
	int min = (msec % 3600000) / 60000;
	int sec = (msec / 1000) % 60;
	QString formedTime = "";

	if( hour > 0 ) formedTime += i18n(" %1 hour").arg(hour);
	if( min > 0 ) formedTime += i18n(" %1 minutes").arg(min);
	formedTime += i18n(" %1 seconds").arg(sec);

	if( logHtml )
	{
		logString += "</TD></TR><TR><TD BGCOLOR=#dddddd >";
		logString += i18n("Time : %1.").arg(formedTime);
	} else {
		logString += ">> " + i18n("Time : %1.").arg(formedTime) + "\n";
	}
}

/** Set action menues */
void Kconfigure::setActionMode( bool isStop, bool stop)
{
	actionStop->setEnabled(stop);
	actionConfigure->setEnabled(isStop);
	actionConfigureHelp->setEnabled(isStop);
	actionConfigureArg->setEnabled(isStop);
	actionQmake->setEnabled(isStop);
	actionQmakeArg->setEnabled(isStop);
	actionMake->setEnabled(isStop);
	actionMakeClean->setEnabled(isStop);
	actionMakeArg->setEnabled(isStop);
	actionInstall->setEnabled(isStop);
}

/** Result compress */
void Kconfigure::slotResult( KIO::Job *job)
{
if (job->error())      job->showErrorDialog();
}

/** Open with extract operation */
bool Kconfigure::openExtractURL(const KURL & url, const QString &extVal)
{
	ExtractDlg tarOptions;
	tarOptions.setFile( url, extVal );
	if(	tarOptions.exec() )
	{
		filePath = tarOptions.getFile().directory(false,true);
		fileName = tarOptions.getFile().fileName();
		recentFiles->addURL( tarOptions.getFile() );
		if( logOn )
		{
			if( logHtml )
			{
				headerHTML( i18n("Extract files in : %1").arg( filePath ) );
				logString += "</TD></TR></TABLE><P></P>";
			} else {
				logString += ">> " + i18n("Extract files in : %1").arg( filePath ) + "\n\n";
			}
		}
		return true;
	} else {
		return false;
	}	
}

void Kconfigure::slotExecuteQmake( )
{
	execute("qmake");
	if( logOn )
	{
		time.start();
		if( logHtml ) {
			headerHTML( i18n("qmake") );
			view_main->insertLine( i18n("**qmake done**\n\n") );
		}
		else {
			logString += ">> " + i18n("qmake") + "\n\n";
			view_main->insertLine( i18n("**qmake done**\n\n") );
		}
	}
}

void Kconfigure::slotExecuteQmake_Args( )
{
	KLineEditDlg argdlg( i18n("Qmake with Arguments"), "", this);
	if(argdlg.exec())
	{
		execute( "qmake "+(argdlg.text()));
		if( logOn )
		{
			time.start();
			if( logHtml )
				headerHTML( i18n("qmake %1").arg(argdlg.text()) );
			else
				logString += ">> " + i18n("qmake %1").arg(argdlg.text()) + "\n\n";
		}
	}
}

/** Check the install selection and install with that program */
void Kconfigure::slotSelectExecuteInstall() {

	KConfig *config = KGlobal::config();
	config->setGroup("InstallOptions");
	int inst = config->readNumEntry( "Use Install", 1 );
	
	switch( inst ) {
	case 0:
		slotExecuteInstallRoot();
		break;
	case 1:
		slotExecuteInstall();
		break;
	case 2:
		slotExecuteCheckInstallRoot();
		break;
	default:
		slotExecuteInstallRoot();
		break;
	}

}
