/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "kdarListViewItem.h"

#include "kdar.h"

#include <dar/libdar.hpp>

#include <qdatetime.h>
#include <qstringlist.h>

QString kdarListViewItem::key( int column,
                             bool ascending ) const
{
    if ( column == 1 ) {
        QString permissions = text( 1 );
        QString file = permissions.left( 1 );
        if ( file == "d" )
            return file;
        else
            return ( QString ) "f";
    } else {
        return QListViewItem::key( column, ascending );
    }
}

int kdarListViewItem::compare( QListViewItem *i, int column, bool ascending ) const
{
        kdarListViewItem * item = static_cast<kdarListViewItem*>( i );

        if ( column == 4 )
        {
                QString s1= text( 4 );
                QString s2= item->text( 4 );
                libdar::deci si1 = libdar::deci( kdar::toStdString( s1 ) );
                libdar::deci si2 = libdar::deci( kdar::toStdString( s2 ) );
                libdar::infinint size1( si1.computer() );
                libdar::infinint size2( si2.computer() );
                if ( size1 > size2 )
                {
                        return 1;
                }
                else if ( size1 < size2 )
                {
                        return -1;
                }
                else return 0; // must be equal, right?

        }
        else if ( column == 5 )
        {
                QDateTime datetime1;
                QDateTime datetime2;
                datetime1 = QDateTime::fromString( text( 5 ), Qt::TextDate );
                datetime2 = QDateTime::fromString( item->text( 5 ), Qt::TextDate );
                if ( datetime1 > datetime2 )
                {
                        return 1;
                }
                else if ( datetime1 < datetime2 )
                {
                        return -1;
                }
                else return 0; // must be equal, right?
        }
        else
        {
                return  key( column, ascending ).localeAwareCompare( item->key( column, ascending) );
        }
}

kdarListViewItem * kdarListViewItem::firstChild()
{
        return static_cast<kdarListViewItem*>( QListViewItem::firstChild() );
}

kdarListViewItem * kdarListViewItem::parent()
{
        return static_cast<kdarListViewItem*>( QListViewItem::parent() );
}

kdarListViewItem * kdarListViewItem::nextSibling()
{
        return static_cast<kdarListViewItem*>( QListViewItem::nextSibling() );
}

QString kdarListViewItem::path() const
{
    //construct a file path to this item from its parents, all the way up
    //to the root item.
    kdarListViewItem *tmpItem = ( kdarListViewItem* )( this );
    if ( !tmpItem )
    {
        return QString( "" );
    }
    kdarListViewItem *newItem = tmpItem->parent();
    if ( !newItem )
    {
        return QString( "" );
    }
    QStringList itemList;
    itemList << tmpItem->text( 0 );
    while( newItem->parent() )
    {
        itemList.prepend( tmpItem->parent()->text( 0 ) );
        tmpItem = tmpItem->parent();
        newItem = tmpItem->parent();
    }
    return itemList.join( "/" );
}

