/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef _KDARLOGFILECOMMANDEVENT_H_
#define _KDARLOGFILECOMMANDEVENT_H_

#include "kdarEnums.h"

#include <qevent.h>
#include <qstring.h>

/**
 * This class conveys a command from a KDarThread to the controller
 * to open or close the log file.
 *
 * @short Event for opening or closing the log file.
 * @author Johnathan K. Burchill, jkerrb@users.sourceforge.net
 * @version 1.3.0
 */

class kdarLogFileCommandEvent : public QCustomEvent
{
public:
    enum logFileCommand
    {
        OPEN,
        CLOSE,
        WRITEMESSAGE,
        FLUSH
    };

    /**
     * Constructor
     */
    kdarLogFileCommandEvent( logFileCommand command, QString text = QString::null )
        : QCustomEvent( KDar::LOGFILECOMMAND ),
          m_command( command ),
          m_text( text )
    {}

    /**
     * Returns whether to open or close the log file.
     */
    logFileCommand command() const { return m_command; }
    /**
     * Returns the log file to open
     */
    QString text() const { return m_text; }

private:

    /**
     * Stores the log file command.
     */
    logFileCommand m_command;
    /**
     * When @ref command is @ref OPEN, stores the log file name.
     * When @ref command is @ref WRITEMESSAGE, stores the message to write to
     * the logfile.
     */
    QString m_text;
};

#endif // _KDARLOGFILECOMMANDEVENT_H_
