/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _OPENARCHIVETHREAD_H_
#define _OPENARCHIVETHREAD_H_

#include "kdarthread.h"

/**
 * This is the openArchiveThread class. It opens an archive that already
 * exists.
 *
 * @short Thread for opening an archive.
 * @author Johnathan K. Burchill, jkerrb@users.sourceforge.net
 * @version 1.3.0
 */
class openArchiveThread : public KDarThread {

public:
    /**
     * Constructor
     * @param aController the controller responsible for deleting the thread.
     * @param kdarconfig the configuration object (main, create or restore) for this
     * thread.
     */
    openArchiveThread( controller * aController, KDarConfig  * kdarconfig, bool updateListView = true );
    ~openArchiveThread();

    void run();

private:
    bool m_updateListView;
};


#endif // _OPENARCHIVETHREAD_H_
