/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "restoreArchiveThread.h"

#include "kdar.h"
#include "kdarConfig.h"
#include "kdardeclarations.h"
#include "KDarInteraction.h"
#include "kdarListViewItem.h"
#include "kdarSetCursorEvent.h"
#include "kdarstatistics.h"
#include "kdarStatusBarEvent.h"
#include "kdarWarningEvent.h"

#include <kcursor.h>
#include <kdebug.h>
#include <klocale.h>

#include <qdatetime.h>
#include <qstring.h>

#include <dar/libdar.hpp>
#include <dar/erreurs.hpp>

#include <string>

extern bool libdarWorking;
extern libdar::archive *theArchive;
extern QString extractArchiveDirectory;

restoreArchiveThread::restoreArchiveThread( controller * aController, KDarConfig * kdarconfig, KListView * archiveFileView )
    : KDarThread ( aController, kdarconfig, archiveFileView )
{}

restoreArchiveThread::~restoreArchiveThread()
{}

void restoreArchiveThread::run()
{
    //Every class that is derived from KDarThread must set this member variable:
    m_threadID = pthread_self();

    libdarWorking = true;
    QDateTime startTime = QDateTime::currentDateTime();
    openLogFile();
    setWaitCursor();
    enableCancelButton();
    logMessage( "\n" + i18n( "BEGIN RESTORE: " ) + QDateTime::currentDateTime().toString( "ddd dd MMM yyyy hh:mm:ss" ) + " " + m_kdc->archiveName() + "\n", true );
    logMessage( i18n( "command line: " ) + m_kdc->buildDarCommandLine( KDar::LIBDAR_RESTORE ) + "\n", true );
    statusMessage( i18n( "Restoring files...\n" ), FOREVER );

    libdar::et_mask subtree = m_kdc->libdarCreateDirectoryMask();
    libdar::ou_mask subIncludes = buildDirectoryMaskFromListView( m_kdc->extractArchiveDirectory() );
    if ( subIncludes.size() > 0 ) subtree.add_mask( subIncludes );
    bool destroy( !m_kdc->noDelete() );

    //Need some way to interact with user:
    KDarInteraction userInteractionDialog( m_controller );

    try
    {
//TODO put these in KDarConfig:
        bool warnRemoveNoMatch = false;
//EndTODO
        KDarStatistics ks = theArchive->op_extract( userInteractionDialog, kdar::toStdString( m_kdc->extractArchiveDirectory() ), m_kdc->libdarCreateFileMask(), subtree, m_kdc->allowOverwrite(), m_kdc->warnOnOverwrite(), m_kdc->verbose(), destroy, m_kdc->restoreRecent(), m_kdc->systemEA(), m_kdc->userEA(), m_kdc->flatRestore(), m_kdc->ignoreID(), warnRemoveNoMatch, (libdar::infinint) m_kdc->hourShiftInt(), m_kdc->dryRun() );
        logMessage( ks.restoreStatistics( (KDar::logLevel) m_kdc->logLevel() ) );
        statusMessage( i18n( "Restoring files...done.\n" ) );
        logMessage( timeDifference( startTime, QDateTime::currentDateTime() ) );
    }
    catch( libdar::Euser_abort &e )
    {
        QString errorMessage = i18n( "Restoring archive...cancelled by user." );
        statusMessage( errorMessage );
        logMessage( errorMessage );
    }
    catch( libdar::Egeneric &e )
    {
        userInteractionDialog.warning( e.get_message() );
        QString errorMessage = i18n( "Restoring archive...ERROR: could not restore archive." );
        statusMessage( errorMessage );
        logMessage( e.get_message().c_str() );
        logMessage( errorMessage );
    }
    setNormalCursor();
    disableCancelButton();
    m_endMessage = i18n( "END RESTORE: " ) + QDateTime::currentDateTime().toString( "ddd dd MMM yyyy hh:mm:ss" ) + " " + m_kdc->archiveName() + "\n";
    libdarWorking = false;
    deleteMe();
}

