/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _TESTARCHIVETHREAD_H_
#define _TESTARCHIVETHREAD_H_

#include "kdarthread.h"

/**
 * This is the testArchiveThread class. It runs the
 * libdar:op_test testing function, which verifies the archive contents
 * using a CRC.
 *
 * @short Archive testing thread.
 * @author Johnathan K. Burchill, jkerrb@users.sourceforge.net
 * @version 1.3.0
 */
class testArchiveThread : public KDarThread {

public:
    /**
     * Constructor
     * @param aController the controller responsible for deleting the thread.
     * @param kdarconfig the configuration object (main, create or restore) for this
     * thread.
     */
    testArchiveThread( controller * aController, KDarConfig * kdarconfig, KListView * archiveFileView );
    ~testArchiveThread();

    void run();
};



#endif // _TESTARCHIVETHREAD_H_
