/*
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/

#ifndef DEBAPT_IFACE_H
#define DEBAPT_IFACE_H

#include <kaction.h>

#include "debInterface.h"
//Added by qt3to4:
#include <Q3PtrList>

#define APT_SOURCE "/etc/apt/sources.list"

class DEBAPT: public DEB
{
  Q_OBJECT

public:
  DEBAPT();
  ~DEBAPT();

  virtual bool isType(char *buf, const QString &fname);

  void listPackages(Q3PtrList<packageInfo> *pki);
  QStringList listInstalls(const QStringList &packs, bool install, bool &cancel);

  QString doUninstall(int uninstallFlags, const QString &packs, bool &test);
  QString doInstall(int installFlags, const QString &packs, bool &test);
  QString install(int installFlags, Q3PtrList<packageInfo> *p,
		  bool &test);

  virtual QStringList FindFile(const QString &name, bool seachAll=false);

  void listRemotePackages(Q3PtrList<packageInfo> *pki);
  QStringList getFileList(packageInfo *p);

  QAction *updateM, *upgradeM, *fixupM, *fileM;

  void makeMenu(KActionCollection* act);
  void setMenu(KActionCollection* act, bool enable);

  QStringList readApt();
  QStringList readAptS();
  QStringList readAptF();
  void writeApt(const QStringList &list);

private slots:
  void updateS();	
  void upgradeS();
  void fixupS();
  void fileS();

private:
  void listAvail(Q3PtrList<packageInfo> *pki);
  void listRPack(Q3PtrList<packageInfo> *pki);
  QStringList getRFileList(packageInfo *p);

  QString env;
};
#endif
