/*
	Copyright (C) 2003-2006 Cies Breijs <cies AT kde DOT nl>

	This program is free software; you can redistribute it and/or
	modify it under the terms of version 2 of the GNU General Public
	License as published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to the Free
	Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
	Boston, MA 02110-1301, USA.
*/


#ifndef _ECHOER_H_
#define _ECHOER_H_

#include <iostream>

#include "executer.h"


/**
 * @short Echoes signals to a QTextStream
 *
 * Just echos the signals it gets.
 * Usefull for creating UnitTests.
 *
 * @author Cies Breijs
 */
class Echoer : public QObject
{
	Q_OBJECT

	public:
		/**
		 * Default Constructor
		 */
		Echoer(QObject* parent = 0) { setParent(parent); }

		/**
		 * Default Destructor
		 */
		virtual ~Echoer() {}

		/**
		 * Connects all its slots to the signals of the Executer
		 */
		void connectAllSlots(Executer* executer) {
			// these connect calls connect all the Executers signals to this class' slots

//BEGIN GENERATED echoer_connect_h CODE

/* The code between the line that start with "//BEGIN GENERATED" and "//END GENERATED"
 * is generated by "generate.rb" according to the definitions specified in
 * "definitions.rb". Please make all changes in the "definitions.rb" file, since all
 * all change you make here will be overwritten the next time "generate.rb" is run.
 * Thanks for looking at the code!
 */

			connect(executer, SIGNAL(reset()),
				SLOT(reset()));
			connect(executer, SIGNAL(clear()),
				SLOT(clear()));
			connect(executer, SIGNAL(center()),
				SLOT(center()));
			connect(executer, SIGNAL(go(double, double)),
				SLOT(go(double, double)));
			connect(executer, SIGNAL(goX(double)),
				SLOT(goX(double)));
			connect(executer, SIGNAL(goY(double)),
				SLOT(goY(double)));
			connect(executer, SIGNAL(forward(double)),
				SLOT(forward(double)));
			connect(executer, SIGNAL(backward(double)),
				SLOT(backward(double)));
			connect(executer, SIGNAL(direction(double)),
				SLOT(direction(double)));
			connect(executer, SIGNAL(turnLeft(double)),
				SLOT(turnLeft(double)));
			connect(executer, SIGNAL(turnRight(double)),
				SLOT(turnRight(double)));
			connect(executer, SIGNAL(penWidth(double)),
				SLOT(penWidth(double)));
			connect(executer, SIGNAL(penUp()),
				SLOT(penUp()));
			connect(executer, SIGNAL(penDown()),
				SLOT(penDown()));
			connect(executer, SIGNAL(penColor(double, double, double)),
				SLOT(penColor(double, double, double)));
			connect(executer, SIGNAL(canvasColor(double, double, double)),
				SLOT(canvasColor(double, double, double)));
			connect(executer, SIGNAL(spriteShow()),
				SLOT(spriteShow()));
			connect(executer, SIGNAL(spriteHide()),
				SLOT(spriteHide()));
			connect(executer, SIGNAL(print(const QString&)),
				SLOT(print(const QString&)));
			connect(executer, SIGNAL(fontSize(double)),
				SLOT(fontSize(double)));

//END GENERATED echoer_connect_h CODE
		}


	public slots:
		// the generated code is a set of slots that are covering all the Executers signals...

//BEGIN GENERATED echoer_slots_h CODE

/* The code between the line that start with "//BEGIN GENERATED" and "//END GENERATED"
 * is generated by "generate.rb" according to the definitions specified in
 * "definitions.rb". Please make all changes in the "definitions.rb" file, since all
 * all change you make here will be overwritten the next time "generate.rb" is run.
 * Thanks for looking at the code!
 */

		void reset() { std::cout << "SIG> " << "reset" << "(" << ")" << std::endl; }
		void clear() { std::cout << "SIG> " << "clear" << "(" << ")" << std::endl; }
		void center() { std::cout << "SIG> " << "center" << "(" << ")" << std::endl; }
		void go(double arg0, double arg1) { std::cout << "SIG> " << "go" << "(" << arg0 << "," << arg1 << ")" << std::endl; }
		void goX(double arg0) { std::cout << "SIG> " << "goX" << "(" << arg0 << ")" << std::endl; }
		void goY(double arg0) { std::cout << "SIG> " << "goY" << "(" << arg0 << ")" << std::endl; }
		void forward(double arg0) { std::cout << "SIG> " << "forward" << "(" << arg0 << ")" << std::endl; }
		void backward(double arg0) { std::cout << "SIG> " << "backward" << "(" << arg0 << ")" << std::endl; }
		void direction(double arg0) { std::cout << "SIG> " << "direction" << "(" << arg0 << ")" << std::endl; }
		void turnLeft(double arg0) { std::cout << "SIG> " << "turnLeft" << "(" << arg0 << ")" << std::endl; }
		void turnRight(double arg0) { std::cout << "SIG> " << "turnRight" << "(" << arg0 << ")" << std::endl; }
		void penWidth(double arg0) { std::cout << "SIG> " << "penWidth" << "(" << arg0 << ")" << std::endl; }
		void penUp() { std::cout << "SIG> " << "penUp" << "(" << ")" << std::endl; }
		void penDown() { std::cout << "SIG> " << "penDown" << "(" << ")" << std::endl; }
		void penColor(double arg0, double arg1, double arg2) { std::cout << "SIG> " << "penColor" << "(" << arg0 << "," << arg1 << "," << arg2 << ")" << std::endl; }
		void canvasColor(double arg0, double arg1, double arg2) { std::cout << "SIG> " << "canvasColor" << "(" << arg0 << "," << arg1 << "," << arg2 << ")" << std::endl; }
		void spriteShow() { std::cout << "SIG> " << "spriteShow" << "(" << ")" << std::endl; }
		void spriteHide() { std::cout << "SIG> " << "spriteHide" << "(" << ")" << std::endl; }
		void print(const QString& arg0) { std::cout << "SIG> " << "print" << "(" << qPrintable(arg0) << ")" << std::endl; }
		void fontSize(double arg0) { std::cout << "SIG> " << "fontSize" << "(" << arg0 << ")" << std::endl; }

//END GENERATED echoer_slots_h CODE

};

#endif  // _ECHOER_H_


