#include "main.h"
#include "mainwindow.moc"

#include <klocale.h>
#include <kaction.h>
#include <kactioncollection.h>
#include <kstandardaction.h>
#include <kkeydialog.h>
#include <kconfigdialog.h>

#include "inter.h"
#include "common_factory.h"
//Added by qt3to4:

void MainWindow::addConfig(KConfigDialog *dialog)
{
    QWidget *w = cfactory->createAIConfig();
    if (w) dialog->addPage(w, i18n("A.I."), "personal");
}

void MainWindow::init()
{
    Interface *inter = static_cast<Interface *>(_inter);
    inter->normalGame();
    setFocusPolicy(Qt::StrongFocus);

    // Modes
    bool ama = ( bfactory->bbi.nbArcadeStages!=0 );
    QString s = (ama ? i18n("&Single Human (Normal)") : i18n("&Single Human"));
    QAction *action = actionCollection()->addAction("mp_single_human");
    action->setText(s);
    connect(action, SIGNAL(triggered(bool) ), inter, SLOT(normalGame()));
    if (ama) {
       action = actionCollection()->addAction("mp_arcade");
       action->setText(i18n("&Single Human (Arcade)"));
       connect(action, SIGNAL(triggered(bool) ), inter, SLOT(arcadeGame()));
    }
    action = actionCollection()->addAction("mp_human_vs_human");
    action->setText(i18n("Human vs &Human"));
    connect(action, SIGNAL(triggered(bool) ), inter, SLOT(humanVsHuman()));
    action = actionCollection()->addAction("mp_human_vs_computer");
    action->setText(i18n("Human vs &Computer"));
    connect(action, SIGNAL(triggered(bool) ), inter, SLOT(humanVsComputer()));
    action = actionCollection()->addAction("mp_more");
    action->setText(i18n("&More..."));
    connect(action, SIGNAL(triggered(bool) ), inter, SLOT(dialog()));

    buildGUI(inter);
    connect(this, SIGNAL(settingsChanged()),
            inter, SLOT(settingsChangedSlot()));
}

void MainWindow::addKeys(KKeyDialog &d)
{
    static_cast<Interface *>(_inter)->addKeys(d);
}

void MainWindow::saveKeys()
{
    static_cast<Interface *>(_inter)->saveKeys();
}

void MainWindow::focusInEvent(QFocusEvent *e)
{
    static_cast<Interface *>(_inter)->setFocus();
    BaseMainWindow::focusInEvent(e);
}
